/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.log.ILogger;
import java.text.MessageFormat;

public abstract class AbstractLogger
implements ILogger {
    @Override
    public void debug(Object message) {
        if (this.isDebug()) {
            this.log(message, null, Level.DEBUG);
        }
    }

    @Override
    public void debug(Object message, Throwable e) {
        if (this.isDebug()) {
            this.log(message, e, Level.DEBUG);
        }
    }

    @Override
    public void debugFormat(String message, Object args) {
        if (this.isDebug()) {
            this.logArgs(message, args, Level.DEBUG);
        }
    }

    @Override
    public void info(Object message) {
        if (this.isInfo()) {
            this.log(message, null, Level.INFO);
        }
    }

    @Override
    public void info(Object message, Throwable e) {
        if (this.isInfo()) {
            this.log(message, e, Level.INFO);
        }
    }

    @Override
    public void infoFormat(String message, Object args) {
        if (this.isInfo()) {
            this.logArgs(message, args, Level.INFO);
        }
    }

    @Override
    public void error(Object message) {
        if (this.isError()) {
            this.log(message, null, Level.ERROR);
        }
    }

    @Override
    public void error(Object message, Throwable e) {
        if (this.isError()) {
            this.log(message, e, Level.ERROR);
        }
    }

    @Override
    public void errorFormat(String message, Object args) {
        if (this.isError()) {
            this.logArgs(message, args, Level.ERROR);
        }
    }

    @Override
    public void warn(Object message) {
        if (this.isWarn()) {
            this.log(message, null, Level.WARN);
        }
    }

    @Override
    public void warn(Object message, Throwable e) {
        if (this.isWarn()) {
            this.log(message, e, Level.WARN);
        }
    }

    @Override
    public void warnFormat(String message, Object args) {
        if (this.isWarn()) {
            this.logArgs(message, args, Level.WARN);
        }
    }

    @Override
    public void fatalError(Object message) {
        if (this.isFatalError()) {
            this.log(message, null, Level.FATAL_ERROR);
        }
    }

    @Override
    public void fatalError(Object message, Throwable e) {
        if (this.isFatalError()) {
            this.log(message, e, Level.FATAL_ERROR);
        }
    }

    @Override
    public void fatalErrorFormat(String message, Object args) {
        if (this.isFatalError()) {
            this.logArgs(message, args, Level.FATAL_ERROR);
        }
    }

    protected abstract void log(Object var1, Throwable var2, Level var3);

    protected abstract void logArgs(String var1, Object var2, Level var3);

    protected static String formatMessage(String format, Object args) {
        if (args != null) {
            Class<?> clazz = args.getClass();
            if (clazz == Object[].class) {
                return MessageFormat.format(format, (Object[])args);
            }
            if (clazz == String[].class) {
                Object[] argsO = new Object[((String[])args).length];
                for (int i = 0; i < argsO.length; ++i) {
                    argsO[i] = ((String[])args)[i];
                }
                return MessageFormat.format(format, argsO);
            }
        }
        return MessageFormat.format(format, args);
    }

    protected static class Level
    extends GEnum {
        public static final Level DEBUG = new Level(0, "DEBUG");
        public static final Level INFO = new Level(1, "INFO");
        public static final Level WARN = new Level(2, "WARN");
        public static final Level ERROR = new Level(3, "ERROR");
        public static final Level FATAL_ERROR = new Level(4, "FATAL_ERROR");

        private Level(int ordinal, String name) {
            super(ordinal, name, Level.class);
        }
    }
}

