/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.log.AbstractLogger;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.util.CallstackUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtilLoggerImpl
extends AbstractLogger {
    private Logger impl;

    JavaUtilLoggerImpl(Logger impl) {
        this.impl = impl;
    }

    @Override
    public boolean isFatalError() {
        return this.impl.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isError() {
        return this.impl.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isWarn() {
        return this.impl.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isInfo() {
        return this.impl.isLoggable(Level.INFO);
    }

    @Override
    public boolean isDebug() {
        return this.impl.isLoggable(Level.FINE);
    }

    @Override
    public ILogger createChildLogger(String name) {
        StringBuilder newName = new StringBuilder(this.impl.getName());
        newName.append('.').append(name);
        return new JavaUtilLoggerImpl(Logger.getLogger(newName.toString()));
    }

    @Override
    protected void log(Object message, Throwable e, AbstractLogger.Level level) {
        String className = "unknown";
        String methodName = "unknown";
        StackTraceElement stackElem = CallstackUtils.getStackElementBeforeLog();
        if (stackElem != null) {
            className = stackElem.getClassName();
            methodName = stackElem.getMethodName();
        }
        this.impl.logp(JavaUtilLoggerImpl.getLevel(level), className, methodName, message.toString(), e);
    }

    @Override
    protected void logArgs(String message, Object args, AbstractLogger.Level level) {
        this.log(JavaUtilLoggerImpl.formatMessage(message, args), null, level);
    }

    private static Level getLevel(AbstractLogger.Level level) {
        if (level == AbstractLogger.Level.DEBUG) {
            return Level.FINE;
        }
        if (level == AbstractLogger.Level.INFO) {
            return Level.INFO;
        }
        if (level == AbstractLogger.Level.WARN) {
            return Level.WARNING;
        }
        if (level == AbstractLogger.Level.ERROR) {
            return Level.SEVERE;
        }
        if (level == AbstractLogger.Level.FATAL_ERROR) {
            return Level.SEVERE;
        }
        return Level.FINER;
    }
}

