/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.ILoggerFactory;
import com.genesyslab.platform.commons.log.JavaUtilLoggerFactoryImpl;
import com.genesyslab.platform.commons.log.Log4J2Checker;
import com.genesyslab.platform.commons.log.Log4J2LoggerFactoryImpl;
import com.genesyslab.platform.commons.log.Log4JChecker;
import com.genesyslab.platform.commons.log.Log4JLoggerFactoryImpl;
import com.genesyslab.platform.commons.log.NullLoggerFactoryImpl;
import com.genesyslab.platform.commons.log.NullLoggerImpl;
import com.genesyslab.platform.commons.log.SimpleLoggerFactoryImpl;
import com.genesyslab.platform.commons.log.Slf4JChecker;
import com.genesyslab.platform.commons.log.Slf4JLoggerFactoryImpl;
import com.genesyslab.platform.commons.util.CallstackUtils;
import com.genesyslab.platform.commons.util.PsdkVersionInfo;
import java.nio.charset.Charset;

public final class Log {
    public static final String LOG_FACTORY_LOG4J = "log4j";
    public static final String LOG_FACTORY_LOG4J2 = "log4j2";
    public static final String LOG_FACTORY_SLF4J = "slf4j";
    public static final String LOG_FACTORY_JUL = "jul";
    @Deprecated
    public static final String LOG_FACTORY_JDK = "jdk";
    public static final String LOG_FACTORY_CONSOLE = "console";
    public static final String LOG_FACTORY_AUTO = "auto";
    public static final String LOG_FACTORY_NONE = "none";
    public static final String MESSAGE_RECEIVE_LOGGER_NAME = "com.genesyslab.platformmessage.receive";
    public static final String MESSAGE_REQUEST_LOGGER_NAME = "com.genesyslab.platformmessage.request";
    private static final boolean LOG_FACTORY_DEBUG = PsdkCustomization.getOption(PsdkCustomization.PsdkOption.PsdkLoggerDebug) != null;
    private static volatile WrappedLogerFactory loggerFactory = null;
    private static boolean areJarsVersionsPrinted;
    private static String envInfo;
    private static String envInfoEx;

    private Log() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getLogger(String name) {
        ILogger log = null;
        WrappedLogerFactory lFactory = Log.getLoggerFactory();
        try {
            log = lFactory.getLogger(name);
        }
        catch (Throwable e) {
            if (LOG_FACTORY_DEBUG) {
                System.err.print("Exception creating logger: ");
                System.err.println(e.toString());
            }
        }
        finally {
            if (log == null) {
                log = new WrappedLogger(NullLoggerImpl.SINGLETON, name, lFactory);
            }
        }
        return log;
    }

    public static ILogger getMessageFilteringLogger() {
        return Log.getLogger("com.genesyslab.platformmessage.filtering");
    }

    @Deprecated
    public static ILogger getDataLogger() {
        if (Log.isMessagesTraceEnabled(null)) {
            return Log.getLogger("com.genesyslab.platformmessages");
        }
        return NullLoggerImpl.SINGLETON;
    }

    public static boolean isMessagesTraceEnabled(String protocolName) {
        return PsdkCustomization.getBoolOption(PsdkCustomization.PsdkOption.PsdkLoggerTraceMessages, protocolName, Boolean.FALSE);
    }

    public static ILogger getRequestLogger(String protocolName) {
        if (Log.isMessagesTraceEnabled(protocolName)) {
            return Log.getLogger(MESSAGE_REQUEST_LOGGER_NAME);
        }
        return NullLoggerImpl.SINGLETON;
    }

    public static ILogger getReceiveLogger(String protocolName) {
        if (Log.isMessagesTraceEnabled(protocolName)) {
            return Log.getLogger(MESSAGE_RECEIVE_LOGGER_NAME);
        }
        return NullLoggerImpl.SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILogger getLogger(Class clazz) {
        ILogger log;
        block6: {
            String name;
            log = null;
            WrappedLogerFactory lFactory = Log.getLoggerFactory();
            try {
                log = lFactory.getLogger(clazz);
                if (log != null) break block6;
                name = clazz != null ? clazz.getName() : "";
            }
            catch (Throwable e) {
                String name2;
                try {
                    if (LOG_FACTORY_DEBUG) {
                        System.err.print("Exception creating logger: ");
                        System.err.println(e.toString());
                    }
                    if (log != null) break block6;
                    name2 = clazz != null ? clazz.getName() : "";
                }
                catch (Throwable throwable) {
                    if (log == null) {
                        String name3 = clazz != null ? clazz.getName() : "";
                        log = new WrappedLogger(NullLoggerImpl.SINGLETON, name3, lFactory);
                    }
                    throw throwable;
                }
                log = new WrappedLogger(NullLoggerImpl.SINGLETON, name2, lFactory);
            }
            log = new WrappedLogger(NullLoggerImpl.SINGLETON, name, lFactory);
        }
        return log;
    }

    public static void setLoggerFactory(String factoryName) {
        ILoggerFactory factory = null;
        Class<? extends ILoggerFactory> factoryClass = Log.getLoggerFactoryClass(factoryName);
        if (factoryClass != null) {
            try {
                factory = factoryClass.newInstance();
            }
            catch (Throwable thr) {
                throw new IllegalArgumentException("Can't create LoggerFactory with name " + factoryName, thr);
            }
        } else {
            throw new IllegalArgumentException("Can't create LoggerFactory with name " + factoryName);
        }
        Log.setLoggerFactory(factory);
    }

    public static synchronized void setLoggerFactory(ILoggerFactory factory) {
        if (factory != null) {
            ILogger logger;
            boolean debug;
            WrappedLogerFactory loggerFactoryOld = loggerFactory;
            boolean bl = debug = LOG_FACTORY_DEBUG && factory != loggerFactory;
            if (debug && loggerFactoryOld != null) {
                logger = loggerFactoryOld.getLogger(Log.class);
                Log.logCallStack("Changing logger factory to " + factory + " from " + loggerFactoryOld, logger);
            }
            loggerFactory = Log.wrap(factory);
            if (debug) {
                logger = factory.getLogger(Log.class);
                Log.logCallStack("Changed logger factory to " + factory + " from " + loggerFactoryOld, logger);
            }
            Log.printPSDKVersions();
        }
    }

    private static void logCallStack(String info, ILogger logger) {
        logger.info(info + "\n[CALLSTACK]\n" + CallstackUtils.getCallstackInfo(1));
    }

    @Deprecated
    public static String getCallStackInfo() {
        return "[CALLSTACK]" + CallstackUtils.getCallstackInfo(1);
    }

    private static synchronized WrappedLogerFactory getLoggerFactory() {
        if (loggerFactory == null) {
            Log.setLoggerFactory(new NullLoggerFactoryImpl());
        }
        return loggerFactory;
    }

    private static void initLoggerFactory() {
        block2: {
            try {
                Log.setLoggerFactory(PsdkCustomization.getOption(PsdkCustomization.PsdkOption.PsdkLoggerFactory));
            }
            catch (Throwable thr) {
                if (!LOG_FACTORY_DEBUG) break block2;
                System.err.print("Exception creating logger factory");
                thr.printStackTrace();
            }
        }
    }

    private static Class<? extends ILoggerFactory> getLoggerFactoryClass(String factoryClassName) {
        Class factoryClass;
        block21: {
            factoryClass = null;
            if (factoryClassName != null && !factoryClassName.isEmpty()) {
                try {
                    if (factoryClassName.equalsIgnoreCase(LOG_FACTORY_AUTO)) {
                        factoryClass = Log4J2Checker.isAvailable() ? Log4J2LoggerFactoryImpl.class : (Slf4JChecker.isAvailable() ? Slf4JLoggerFactoryImpl.class : (Log4JChecker.isAvailable() ? Log4JLoggerFactoryImpl.class : JavaUtilLoggerFactoryImpl.class));
                    } else if (factoryClassName.equalsIgnoreCase(LOG_FACTORY_LOG4J2)) {
                        factoryClass = Log4J2LoggerFactoryImpl.class;
                    } else if (factoryClassName.equalsIgnoreCase(LOG_FACTORY_LOG4J)) {
                        factoryClass = Log4JLoggerFactoryImpl.class;
                    } else if (factoryClassName.equalsIgnoreCase(LOG_FACTORY_SLF4J)) {
                        factoryClass = Slf4JLoggerFactoryImpl.class;
                    } else if (factoryClassName.equalsIgnoreCase(LOG_FACTORY_JUL)) {
                        factoryClass = JavaUtilLoggerFactoryImpl.class;
                    } else if (factoryClassName.equalsIgnoreCase(LOG_FACTORY_JDK)) {
                        factoryClass = JavaUtilLoggerFactoryImpl.class;
                    } else if (factoryClassName.equalsIgnoreCase(LOG_FACTORY_CONSOLE)) {
                        factoryClass = SimpleLoggerFactoryImpl.class;
                    } else if (factoryClassName.equalsIgnoreCase(LOG_FACTORY_NONE)) {
                        factoryClass = NullLoggerFactoryImpl.class;
                    } else {
                        Class<?> fClass = Class.forName(factoryClassName);
                        if (!ILoggerFactory.class.isAssignableFrom(fClass)) {
                            throw new IllegalArgumentException("Logger factory \"" + factoryClassName + "\" has to implement ILoggerFactory interface");
                        }
                        factoryClass = fClass;
                    }
                }
                catch (Throwable thr) {
                    if (!LOG_FACTORY_DEBUG) break block21;
                    System.err.println("Exception while initializing logger factory");
                    thr.printStackTrace();
                }
            }
        }
        if (factoryClass == null) {
            return NullLoggerFactoryImpl.class;
        }
        return factoryClass;
    }

    private static void printPSDKVersions() {
        ILogger logger;
        if (!areJarsVersionsPrinted && (logger = Log.getLogger(Log.class)).isInfo()) {
            StringBuilder msg;
            logger.infoFormat("Environment information: {0}", Log.getEnvInfo());
            logger.info("Checking PSDK jars versions:");
            for (String[] version : PsdkVersionInfo.getJarsVersions()) {
                msg = new StringBuilder("PSDK jar in the classpath: ");
                msg.append(version[0]);
                if (version[1] != null) {
                    msg.append(" of ").append(version[1]);
                }
                if (version[2] != null || version[3] != null) {
                    msg.append(" (");
                    if (version[2] != null) {
                        msg.append(version[2]);
                        if (version[3] != null) {
                            msg.append(' ');
                        }
                    }
                    if (version[3] != null) {
                        msg.append("by ").append(version[3]);
                    }
                    msg.append(')');
                }
                logger.info(msg.toString());
            }
            for (String[] version : PsdkVersionInfo.get3rdPartiesJarsVersions()) {
                msg = new StringBuilder("Third-party jar in the classpath: ");
                msg.append(version[0]);
                if (version[1] != null) {
                    msg.append(" of ").append(version[1]);
                }
                if (version[2] != null || version[3] != null) {
                    msg.append(" (");
                    if (version[2] != null) {
                        msg.append(version[2]);
                        if (version[3] != null) {
                            msg.append(' ');
                        }
                    }
                    if (version[3] != null) {
                        msg.append("by ").append(version[3]);
                    }
                    msg.append(')');
                }
                logger.info(msg.toString());
            }
            areJarsVersionsPrinted = true;
        }
    }

    private static String getEnvInfo() {
        if (envInfo == null) {
            String str;
            try {
                str = System.getProperty("os.name") + "/" + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + "/" + System.getProperty("java.version") + "/" + System.getProperty("java.vm.version") + "/" + Charset.defaultCharset();
            }
            catch (Throwable thr) {
                str = "unknown env";
            }
            envInfo = str;
        }
        return envInfo;
    }

    private static String getExEnvInfo() {
        if (envInfoEx == null) {
            envInfoEx = " [" + Log.getEnvInfo() + "]";
        }
        return envInfoEx;
    }

    private static WrappedLogerFactory wrap(ILoggerFactory factory) {
        return new WrappedLogerFactory(factory);
    }

    static {
        try {
            Log.initLoggerFactory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        areJarsVersionsPrinted = false;
        envInfo = null;
        envInfoEx = null;
    }

    static class WrappedLogger
    implements ILogger {
        private volatile LogRef logRef;

        public WrappedLogger(ILogger logger, String name, WrappedLogerFactory ref) {
            this.logRef = new LogRef(logger, name, ref);
        }

        @Override
        public void warnFormat(String message, Object args) {
            this.updateLogger();
            this.logRef.getLogger().warnFormat(message, args);
        }

        @Override
        public void warn(Object message, Throwable e) {
            this.updateLogger();
            if (message != null && message.getClass() == String.class) {
                this.logRef.getLogger().warn(message + Log.getExEnvInfo(), e);
            } else {
                this.logRef.getLogger().warn(message, e);
            }
        }

        @Override
        public void warn(Object message) {
            this.updateLogger();
            this.logRef.getLogger().warn(message);
        }

        @Override
        public boolean isWarn() {
            this.updateLogger();
            return this.logRef.getLogger().isWarn();
        }

        @Override
        public boolean isInfo() {
            this.updateLogger();
            return this.logRef.getLogger().isInfo();
        }

        @Override
        public boolean isFatalError() {
            this.updateLogger();
            return this.logRef.getLogger().isFatalError();
        }

        @Override
        public boolean isError() {
            this.updateLogger();
            return this.logRef.getLogger().isError();
        }

        @Override
        public boolean isDebug() {
            this.updateLogger();
            return this.logRef.getLogger().isDebug();
        }

        @Override
        public void infoFormat(String message, Object args) {
            this.updateLogger();
            this.logRef.getLogger().infoFormat(message, args);
        }

        @Override
        public void info(Object message, Throwable e) {
            this.updateLogger();
            if (message != null && message.getClass() == String.class) {
                this.logRef.getLogger().info(message + Log.getExEnvInfo(), e);
            } else {
                this.logRef.getLogger().info(message, e);
            }
        }

        @Override
        public void info(Object message) {
            this.updateLogger();
            this.logRef.getLogger().info(message);
        }

        @Override
        public void fatalErrorFormat(String message, Object args) {
            this.updateLogger();
            this.logRef.getLogger().fatalErrorFormat(message, args);
        }

        @Override
        public void fatalError(Object message, Throwable e) {
            this.updateLogger();
            if (message != null && message.getClass() == String.class) {
                this.logRef.getLogger().fatalError(message + Log.getExEnvInfo(), e);
            } else {
                this.logRef.getLogger().fatalError(message, e);
            }
        }

        @Override
        public void fatalError(Object message) {
            this.updateLogger();
            this.logRef.getLogger().fatalError(message);
        }

        @Override
        public void errorFormat(String message, Object args) {
            this.updateLogger();
            this.logRef.getLogger().errorFormat(message, args);
        }

        @Override
        public void error(Object message, Throwable e) {
            this.updateLogger();
            if (message != null && message.getClass() == String.class) {
                this.logRef.getLogger().error(message + Log.getExEnvInfo(), e);
            } else {
                this.logRef.getLogger().error(message, e);
            }
        }

        @Override
        public void error(Object message) {
            this.updateLogger();
            this.logRef.getLogger().error(message);
        }

        @Override
        public void debugFormat(String message, Object args) {
            this.updateLogger();
            this.logRef.getLogger().debugFormat(message, args);
        }

        @Override
        public void debug(Object message, Throwable e) {
            this.updateLogger();
            if (message != null && message.getClass() == String.class) {
                this.logRef.getLogger().debug(message + Log.getExEnvInfo(), e);
            } else {
                this.logRef.getLogger().debug(message, e);
            }
        }

        @Override
        public void debug(Object message) {
            this.updateLogger();
            this.logRef.getLogger().debug(message);
        }

        @Override
        public ILogger createChildLogger(String name) {
            this.updateLogger();
            LogRef loggerRef = this.logRef;
            return new WrappedLogger(loggerRef.getLogger().createChildLogger(name), loggerRef.loggerName() + "." + name, loggerRef.getFactory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateLogger() {
            WrappedLogerFactory factory = loggerFactory;
            LogRef ref = this.logRef;
            if (factory != null && factory != ref.getFactory()) {
                ILogger logger = null;
                String name = ref.loggerName();
                try {
                    logger = factory.getNotWrappedLogger(name);
                }
                catch (Throwable thr) {
                    if (LOG_FACTORY_DEBUG) {
                        System.err.print("Exception creating logger: ");
                        thr.printStackTrace();
                    }
                }
                finally {
                    if (logger == null) {
                        logger = NullLoggerImpl.SINGLETON;
                    }
                    this.logRef = new LogRef(logger, name, factory);
                }
            }
        }

        private static class LogRef {
            private final ILogger logger;
            private final WrappedLogerFactory ref;
            private final String name;

            public LogRef(ILogger logger, String name, WrappedLogerFactory ref) {
                this.logger = logger;
                this.ref = ref;
                this.name = name;
            }

            public WrappedLogerFactory getFactory() {
                return this.ref;
            }

            public ILogger getLogger() {
                return this.logger;
            }

            public String loggerName() {
                return this.name;
            }
        }
    }

    static class WrappedLogerFactory
    implements ILoggerFactory {
        private final ILoggerFactory factory;

        public WrappedLogerFactory(ILoggerFactory factory) {
            this.factory = factory;
        }

        @Override
        public ILogger getLogger(Class clazz) {
            return this.getLogger(clazz.getName());
        }

        @Override
        public ILogger getLogger(String name) {
            return new WrappedLogger(this.factory.getLogger(name), name, this);
        }

        private ILogger getNotWrappedLogger(String name) {
            return this.factory.getLogger(name);
        }
    }
}

