/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.log.AbstractLogger;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4JLoggerImpl
extends AbstractLogger {
    private static final String FQCN = Log.WrappedLogger.class.getName();
    private Logger impl;

    public Log4JLoggerImpl(Logger impl) {
        this.impl = impl;
    }

    @Override
    public boolean isDebug() {
        return this.impl.isDebugEnabled();
    }

    @Override
    public boolean isInfo() {
        return this.impl.isInfoEnabled();
    }

    @Override
    public boolean isError() {
        return this.impl.isEnabledFor(Priority.ERROR);
    }

    @Override
    public boolean isFatalError() {
        return this.impl.isEnabledFor(Priority.FATAL);
    }

    @Override
    public boolean isWarn() {
        return this.impl.isEnabledFor(Priority.WARN);
    }

    @Override
    public ILogger createChildLogger(String name) {
        String newName = this.impl.getName() + "." + name;
        return new Log4JLoggerImpl(Logger.getLogger((String)newName));
    }

    @Override
    protected void log(Object message, Throwable thr, AbstractLogger.Level level) {
        this.impl.log(FQCN, Log4JLoggerImpl.getPriority(level), message, thr);
    }

    @Override
    protected void logArgs(String message, Object args, AbstractLogger.Level level) {
        this.impl.log(FQCN, Log4JLoggerImpl.getPriority(level), (Object)AbstractLogger.formatMessage(message, args), (Throwable)null);
    }

    private static Priority getPriority(AbstractLogger.Level level) {
        if (level == AbstractLogger.Level.DEBUG) {
            return Priority.DEBUG;
        }
        if (level == AbstractLogger.Level.INFO) {
            return Priority.INFO;
        }
        if (level == AbstractLogger.Level.ERROR) {
            return Priority.ERROR;
        }
        if (level == AbstractLogger.Level.FATAL_ERROR) {
            return Priority.FATAL;
        }
        if (level == AbstractLogger.Level.WARN) {
            return Priority.WARN;
        }
        return Priority.DEBUG;
    }
}

