/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.ILoggerFactory;
import com.genesyslab.platform.commons.log.NullLoggerImpl;
import com.genesyslab.platform.commons.log.SimpleLoggerImpl;
import java.io.PrintStream;

public class SimpleLoggerFactoryImpl
implements ILoggerFactory {
    private final PrintStream printStream;
    private int logLevel;

    public SimpleLoggerFactoryImpl() {
        this(System.out);
    }

    public SimpleLoggerFactoryImpl(int level) {
        this(System.out, level);
    }

    public SimpleLoggerFactoryImpl(PrintStream printStream) {
        this(printStream, PsdkCustomization.getIntOption(PsdkCustomization.PsdkOption.PsdkLoggerConsoleLevel, 1));
    }

    public SimpleLoggerFactoryImpl(PrintStream printStream, int level) {
        this.printStream = printStream;
        this.logLevel = level;
    }

    @Override
    public ILogger getLogger(String name) {
        if (name.startsWith("com.genesyslab.platformmessages")) {
            return NullLoggerImpl.SINGLETON;
        }
        return new SimpleLoggerImpl(name, this.printStream, this.logLevel);
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }
}

