/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.ILoggerFactory;
import com.genesyslab.platform.commons.log.Slf4JChecker;
import com.genesyslab.platform.commons.log.Slf4JLoggerImpl;
import org.slf4j.LoggerFactory;

public class Slf4JLoggerFactoryImpl
implements ILoggerFactory {
    public Slf4JLoggerFactoryImpl() {
        boolean haveFactoryRef = false;
        try {
            haveFactoryRef = LoggerFactory.getILoggerFactory() != null;
        }
        catch (Throwable exeption) {
            throw new IllegalStateException("Failed to initialize Slf4j logging adaptor", exeption);
        }
        if (!haveFactoryRef) {
            throw new IllegalStateException("Can't initialize Slf4j logging adaptor - got no Slf4j logger factory instance");
        }
    }

    @Deprecated
    public static boolean isAvailable() {
        return Slf4JChecker.isAvailable();
    }

    @Override
    public ILogger getLogger(String name) {
        return new Slf4JLoggerImpl(LoggerFactory.getLogger((String)name));
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return new Slf4JLoggerImpl(LoggerFactory.getLogger((Class)clazz));
    }
}

