/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.log.AbstractLogger;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4JLoggerImpl
implements ILogger {
    private static final String FQCN = Log.WrappedLogger.class.getName();
    private static final String PSDK_INT_NAMES_PREFIX = "com.genesyslab.platform";
    public static final Marker PSDK_MESSAGE_MARKER = MarkerFactory.getMarker((String)"PSDK_MESSAGE");
    public static final Marker PSDK_INT_MESSAGE_MARKER = MarkerFactory.getMarker((String)"PSDK_INT_MESSAGE");
    public static final Marker PSDK_FATAL_MESSAGE_MARKER = MarkerFactory.getMarker((String)"PSDK_FATAL_MESSAGE");
    private final Logger impl;
    private final Marker marker;
    private final LocationAwareLogger lal;

    public Slf4JLoggerImpl(Logger impl) {
        this.impl = impl;
        this.lal = impl instanceof LocationAwareLogger ? (LocationAwareLogger)impl : null;
        String name = null;
        if (impl != null) {
            name = impl.getName();
        }
        this.marker = name == null ? null : (name.startsWith(PSDK_INT_NAMES_PREFIX) ? PSDK_INT_MESSAGE_MARKER : PSDK_MESSAGE_MARKER);
    }

    @Override
    public boolean isFatalError() {
        return this.impl.isErrorEnabled();
    }

    @Override
    public void fatalError(Object message) {
        if (this.lal != null) {
            this.lal.log(PSDK_FATAL_MESSAGE_MARKER, FQCN, 40, String.valueOf(message), null, null);
        } else {
            this.impl.error(PSDK_FATAL_MESSAGE_MARKER, String.valueOf(message));
        }
    }

    @Override
    public void fatalError(Object message, Throwable thr) {
        if (this.lal != null) {
            this.lal.log(PSDK_FATAL_MESSAGE_MARKER, FQCN, 40, String.valueOf(message), null, thr);
        } else {
            this.impl.error(PSDK_FATAL_MESSAGE_MARKER, String.valueOf(message), thr);
        }
    }

    @Override
    public void fatalErrorFormat(String message, Object args) {
        if (this.lal != null) {
            this.lal.log(PSDK_FATAL_MESSAGE_MARKER, FQCN, 40, AbstractLogger.formatMessage(message, args), null, null);
        } else {
            this.impl.error(PSDK_FATAL_MESSAGE_MARKER, AbstractLogger.formatMessage(message, args));
        }
    }

    @Override
    public boolean isError() {
        return this.impl.isErrorEnabled();
    }

    @Override
    public void error(Object message) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 40, String.valueOf(message), null, null);
        } else {
            this.impl.error(this.marker, String.valueOf(message));
        }
    }

    @Override
    public void error(Object message, Throwable thr) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 40, String.valueOf(message), null, thr);
        } else {
            this.impl.error(this.marker, String.valueOf(message), thr);
        }
    }

    @Override
    public void errorFormat(String message, Object args) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 40, AbstractLogger.formatMessage(message, args), null, null);
        } else {
            this.impl.error(this.marker, AbstractLogger.formatMessage(message, args));
        }
    }

    @Override
    public boolean isWarn() {
        return this.impl.isWarnEnabled();
    }

    @Override
    public void warn(Object message) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 30, String.valueOf(message), null, null);
        } else {
            this.impl.warn(this.marker, String.valueOf(message));
        }
    }

    @Override
    public void warn(Object message, Throwable thr) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 30, String.valueOf(message), null, thr);
        } else {
            this.impl.warn(this.marker, String.valueOf(message), thr);
        }
    }

    @Override
    public void warnFormat(String message, Object args) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 30, AbstractLogger.formatMessage(message, args), null, null);
        } else {
            this.impl.warn(this.marker, AbstractLogger.formatMessage(message, args));
        }
    }

    @Override
    public boolean isInfo() {
        return this.impl.isInfoEnabled();
    }

    @Override
    public void info(Object message) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 20, String.valueOf(message), null, null);
        } else {
            this.impl.info(this.marker, String.valueOf(message));
        }
    }

    @Override
    public void info(Object message, Throwable thr) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 20, String.valueOf(message), null, thr);
        } else {
            this.impl.info(this.marker, String.valueOf(message), thr);
        }
    }

    @Override
    public void infoFormat(String message, Object args) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 20, AbstractLogger.formatMessage(message, args), null, null);
        } else {
            this.impl.info(this.marker, AbstractLogger.formatMessage(message, args));
        }
    }

    @Override
    public boolean isDebug() {
        return this.impl.isDebugEnabled();
    }

    @Override
    public void debug(Object message) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 10, String.valueOf(message), null, null);
        } else {
            this.impl.debug(this.marker, String.valueOf(message));
        }
    }

    @Override
    public void debug(Object message, Throwable thr) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 10, String.valueOf(message), null, thr);
        } else {
            this.impl.debug(this.marker, String.valueOf(message), thr);
        }
    }

    @Override
    public void debugFormat(String message, Object args) {
        if (this.lal != null) {
            this.lal.log(this.marker, FQCN, 10, AbstractLogger.formatMessage(message, args), null, null);
        } else {
            this.impl.debug(this.marker, AbstractLogger.formatMessage(message, args));
        }
    }

    @Override
    public ILogger createChildLogger(String name) {
        StringBuilder newName = new StringBuilder(this.impl.getName());
        newName.append('.').append(name);
        return new Slf4JLoggerImpl(LoggerFactory.getLogger((String)newName.toString()));
    }

    static {
        PSDK_FATAL_MESSAGE_MARKER.add(PSDK_MESSAGE_MARKER);
    }
}

