/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.management;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.management.PSDKMBeanBase;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public final class PSDKManagementFactory {
    public static final String DOMAIN_GENESYS_PLATFORM_SDK = "com.genesyslab.platform[" + UUID.randomUUID().toString() + "]";
    private static Object mbServer;
    private static final Object srvSync;
    private static final ILogger log;

    public static boolean isJMXAvailable() {
        return mbServer != null;
    }

    public static MBeanServer getPSDKMBeanServer() {
        return (MBeanServer)mbServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object registerMBean(PSDKMBeanBase mbean) {
        if (mbean != null && PSDKManagementFactory.isJMXAvailable()) {
            Object object = srvSync;
            synchronized (object) {
                return PSDKManagementFactory.internalRegisterMBean(mbean);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unregisterMBean(Object objectId) {
        if (objectId != null && PSDKManagementFactory.isJMXAvailable()) {
            Object object = srvSync;
            synchronized (object) {
                return PSDKManagementFactory.internalUnregisterMBean(objectId);
            }
        }
        return false;
    }

    static Object createMBeanName(PSDKMBeanBase mbean) {
        String mbNameExt;
        String mbType;
        if (mbean == null || !PSDKManagementFactory.isJMXAvailable()) {
            return null;
        }
        String strName = mbean.getMBeanDomain();
        if (strName == null) {
            strName = "";
        }
        if ((mbType = mbean.getMBeanType()) == null || mbType.length() == 0) {
            throw new IllegalArgumentException("MBean Type property can't be empty");
        }
        strName = strName + ":type=" + mbType;
        String mbName = mbean.getMBeanName();
        if (mbName != null && mbName.length() > 0) {
            strName = strName + ",name=";
            strName = strName + ObjectName.quote(mbName);
        }
        if ((mbNameExt = mbean.getMBeanNameExtraKeys()) != null) {
            strName = strName + "," + mbNameExt;
        }
        try {
            return new ObjectName(strName);
        }
        catch (Exception e) {
            log.error("Illegal MBean name created (" + strName + ")", e);
            throw new IllegalArgumentException("Illegal MBean name created (" + strName + ")", e);
        }
    }

    private static Object internalRegisterMBean(PSDKMBeanBase mbean) {
        ObjectName objName = (ObjectName)mbean.getMBeanNameId();
        try {
            return PSDKManagementFactory.getPSDKMBeanServer().registerMBean(mbean, objName);
        }
        catch (Exception e) {
            log.error("Exception while registering mbean", e);
            throw new IllegalArgumentException("Exception while registering mbean", e);
        }
    }

    private static boolean internalUnregisterMBean(Object objectId) {
        if (!(objectId instanceof ObjectInstance)) {
            throw new IllegalArgumentException("Unregistration can be done by ObjectInstance only");
        }
        try {
            PSDKManagementFactory.getPSDKMBeanServer().unregisterMBean(((ObjectInstance)objectId).getObjectName());
            return true;
        }
        catch (Exception e) {
            log.error("Exception while unregistering mbean", e);
            throw new RuntimeException("Exception while unregistering mbean", e);
        }
    }

    static {
        srvSync = new Object();
        log = Log.getLogger(PSDKManagementFactory.class);
        try {
            Class<?> classMgmtFactory = Class.forName("java.lang.management.ManagementFactory");
            Method methodGetSrv = classMgmtFactory.getMethod("getPlatformMBeanServer", new Class[0]);
            mbServer = methodGetSrv.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            log.warn("Failed to initialize JMX MBeanServer - working without JMX", e);
            mbServer = null;
        }
    }
}

