/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.threading;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.InvokerEventHandler;
import com.genesyslab.platform.commons.threading.SingleThreadInvoker;
import java.util.HashMap;
import java.util.Map;

class InvokerFactoryImpl
implements InvokerEventHandler {
    private static final ILogger log = Log.getLogger(InvokerFactoryImpl.class);
    private final Map<String, RegistryEntry> registry = new HashMap<String, RegistryEntry>();

    InvokerFactoryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onUnusedInvokerQueueTimout(String invokerName) {
        Map<String, RegistryEntry> map = this.registry;
        synchronized (map) {
            RegistryEntry entry = this.registry.get(invokerName);
            if (entry == null) {
                log.warn("stopping unregistered invoker " + invokerName);
                return true;
            }
            if (entry.usageCount <= 0) {
                this.registry.remove(invokerName);
                entry.invoker.release();
                if (log.isDebug()) {
                    log.debug("[InvokerFactory:" + invokerName + "] removed invoker from registry (new size: " + this.registry.size() + ")");
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInvokerCount() {
        Map<String, RegistryEntry> map = this.registry;
        synchronized (map) {
            return this.registry.size();
        }
    }

    public AsyncInvoker namedInvoker(String name) {
        return this.namedInvoker(name, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncInvoker namedInvoker(String name, int queueSize) {
        SingleThreadInvoker invoker = null;
        Map<String, RegistryEntry> map = this.registry;
        synchronized (map) {
            RegistryEntry entry = this.registry.get(name);
            if (entry != null) {
                invoker = entry.getInvoker();
            } else {
                invoker = new SingleThreadInvoker(name, queueSize, this);
                entry = new RegistryEntry(invoker);
                this.registry.put(name, entry);
            }
            entry.incUsage();
        }
        return invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInvoker(String name) {
        Map<String, RegistryEntry> map = this.registry;
        synchronized (map) {
            RegistryEntry entry = this.registry.get(name);
            if (entry != null) {
                entry.decUsage();
            }
        }
    }

    private class RegistryEntry {
        private final SingleThreadInvoker invoker;
        private volatile int usageCount;
        private volatile long lastRequested;

        public RegistryEntry(SingleThreadInvoker invoker) {
            this.invoker = invoker;
        }

        public int incUsage() {
            this.lastRequested = System.currentTimeMillis();
            if (this.usageCount == 0) {
                this.invoker.used();
            }
            ++this.usageCount;
            if (log.isDebug()) {
                log.debug("[InvokerFactory:" + this.invoker.getName() + "] increased invoker usage counter: " + this.usageCount + " (registry size: " + InvokerFactoryImpl.this.registry.size() + ")");
            }
            return this.usageCount;
        }

        public int decUsage() {
            this.lastRequested = System.currentTimeMillis();
            if (this.usageCount == 1) {
                this.invoker.unused();
            }
            --this.usageCount;
            if (this.usageCount < 0) {
                log.error("[InvokerFactory:" + this.invoker.getName() + "] negative usage counter: " + this.usageCount + " (registry size: " + InvokerFactoryImpl.this.registry.size() + ")");
            } else if (log.isDebug()) {
                log.debug("[InvokerFactory:" + this.invoker.getName() + "] decreased invoker usage counter: " + this.usageCount + " (registry size: " + InvokerFactoryImpl.this.registry.size() + ")");
            }
            return this.usageCount;
        }

        public SingleThreadInvoker getInvoker() {
            return this.invoker;
        }

        public long getLastRequested() {
            return this.lastRequested;
        }
    }
}

