/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.threading;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.InvokerEventHandler;
import com.genesyslab.platform.commons.threading.ThreadHeartbeatCounter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SingleThreadInvoker
implements AsyncInvoker {
    private static final long STOP_DELAY = 500L;
    private static final ILogger log = Log.getLogger(SingleThreadInvoker.class);
    private static final Runnable releaseMarker = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final AtomicInteger liveInvokerCount = new AtomicInteger();
    private static final ArrayList<String> liveInvokers = new ArrayList();
    private static final ArrayList<Worker> activeWorkers = new ArrayList();
    private static final ArrayList<Runnable> listeners = new ArrayList();
    private final String name;
    private final BlockingQueue<Runnable> queue;
    private final Worker worker;

    public SingleThreadInvoker() {
        this(null, null);
    }

    public SingleThreadInvoker(String name) {
        this(name, Integer.MAX_VALUE, null);
    }

    SingleThreadInvoker(String name, InvokerEventHandler handler) {
        this(name, Integer.MAX_VALUE, handler);
    }

    public SingleThreadInvoker(String name, int queueSize) {
        this(name, queueSize, null);
    }

    SingleThreadInvoker(String name, int queueSize, InvokerEventHandler handler) {
        this.name = name;
        this.queue = new LinkedBlockingQueue<Runnable>(queueSize);
        this.worker = new Worker(name, this, handler);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void invoke(Runnable target) {
        this.worker.invoke(target);
    }

    public void release() {
        this.worker.release();
    }

    @Override
    public void dispose() {
        this.worker.dispose();
    }

    Thread thread() {
        return this.worker.thread;
    }

    public void used() {
        this.worker.used();
    }

    public void unused() {
        this.worker.unused();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void increaseLiveInvokerCount(String invokerName) {
        Object[] theListeners = null;
        ArrayList<Runnable> arrayList = listeners;
        synchronized (arrayList) {
            liveInvokers.add(invokerName);
            if (liveInvokerCount.incrementAndGet() == 0 && activeWorkers.size() == 0 && listeners.size() > 0) {
                theListeners = listeners.toArray();
                listeners.clear();
            }
        }
        SingleThreadInvoker.notifyAllStopped(theListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decreaseLiveInvokerCount(String invokerName) {
        Object[] theListeners = null;
        ArrayList<Runnable> arrayList = listeners;
        synchronized (arrayList) {
            liveInvokers.remove(invokerName);
            if (liveInvokerCount.decrementAndGet() == 0 && activeWorkers.size() == 0 && listeners.size() > 0) {
                theListeners = listeners.toArray();
                listeners.clear();
            }
        }
        SingleThreadInvoker.notifyAllStopped(theListeners);
    }

    private static void notifyAllStopped(Object[] listeners) {
        if (listeners != null && listeners.length > 0) {
            if (log.isDebug()) {
                log.debug("All PSDK invokers were stopped");
            }
            for (int i = 0; i < listeners.length; ++i) {
                Runnable listener = (Runnable)listeners[i];
                try {
                    listener.run();
                    continue;
                }
                catch (Throwable e) {
                    if (!log.isError()) continue;
                    log.error("Error in PSDK invokers termination handler " + listener, e);
                }
            }
        }
    }

    public static int getLiveInvokerCount() {
        return liveInvokerCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void awaitTermination(Runnable completionHandler) {
        if (log.isDebug()) {
            log.debug("Wait for termination of PSDK invokers");
        }
        boolean notifyImmediately = false;
        ArrayList<Runnable> arrayList = listeners;
        synchronized (arrayList) {
            int activeWorkersCount = activeWorkers.size();
            if (activeWorkersCount > 0) {
                if (log.isDebug()) {
                    log.debug("Notifies " + activeWorkersCount + " PSDK invoker(s) to stop ASAP");
                }
                for (Worker w : activeWorkers) {
                    w.invoke(releaseMarker);
                }
            }
            if (activeWorkersCount == 0 && liveInvokerCount.get() == 0) {
                notifyImmediately = true;
            } else {
                listeners.add(completionHandler);
            }
        }
        if (notifyImmediately) {
            if (log.isDebug()) {
                log.debug("All PSDK Invokers were stopped");
            }
            completionHandler.run();
        }
    }

    @Deprecated
    public static String getStateInfo() {
        Object[] names = liveInvokers.toArray();
        if (names != null && names.length > 0) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("   Live invokers: ");
            sb.append(names.length);
            sb.append("\n");
            for (Object name : names) {
                sb.append("      ");
                sb.append(name);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "";
    }

    static class Worker
    implements Runnable {
        private final String name;
        private volatile InvokerEventHandler handler;
        private final BlockingQueue<Runnable> queue;
        private volatile Thread thread;
        private volatile boolean used;
        private long unusedTime;
        private boolean released;
        private boolean disposed;
        private ReferenceQueue<AsyncInvoker> invokerRefQueue;
        private WeakReference<AsyncInvoker> invokerRef;
        private boolean live;

        public Worker(String name, SingleThreadInvoker invoker, InvokerEventHandler handler) {
            this.name = name;
            this.handler = handler;
            this.queue = invoker.queue;
            this.used = true;
            this.unusedTime = System.currentTimeMillis();
            this.released = false;
            this.disposed = false;
            this.invokerRefQueue = new ReferenceQueue();
            this.invokerRef = new WeakReference<AsyncInvoker>(invoker, this.invokerRefQueue);
            this.live = true;
            SingleThreadInvoker.increaseLiveInvokerCount(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Runnable task) {
            try {
                Worker worker = this;
                synchronized (worker) {
                    if (this.disposed) {
                        if (task == releaseMarker) {
                            return;
                        }
                        throw new IllegalStateException("Invoker is not active (has been stopped)");
                    }
                    if (this.thread == null || !this.thread.isAlive()) {
                        if (task == releaseMarker) {
                            return;
                        }
                        this.startThread();
                    }
                    if (!this.queue.offer(task, 0L, TimeUnit.MILLISECONDS)) {
                        log.warn("Invoker is overloaded!");
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void startThread() {
            String threadName = "com.genesyslab.PCT.invoker";
            if (this.name != null) {
                threadName = threadName + "." + this.name;
            }
            this.thread = new Thread((Runnable)this, threadName);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            boolean justDead = false;
            Worker worker = this;
            synchronized (worker) {
                if (!this.released) {
                    if (log.isDebug()) {
                        log.debug("release invoker: " + this.name);
                    }
                    this.released = true;
                    if (!this.queue.offer(releaseMarker)) {
                        log.debug("failed to add release marker to invoker: " + this.name);
                    }
                    if (this.live) {
                        this.live = false;
                        justDead = true;
                    }
                }
            }
            if (justDead) {
                SingleThreadInvoker.decreaseLiveInvokerCount(this.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            boolean justDead = false;
            Worker worker = this;
            synchronized (worker) {
                if (!this.disposed) {
                    if (log.isDebug()) {
                        log.debug("dispose invoker: " + this.name);
                    }
                    this.disposed = true;
                    if (this.thread != null) {
                        this.thread.interrupt();
                    }
                    if (this.live) {
                        this.live = false;
                        justDead = true;
                    }
                }
            }
            if (justDead) {
                SingleThreadInvoker.decreaseLiveInvokerCount(this.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void used() {
            boolean justLive = false;
            Worker worker = this;
            synchronized (worker) {
                if (!this.used) {
                    if (log.isDebug()) {
                        log.debug("used invoker: " + this.name);
                    }
                    this.used = true;
                    if (!this.live) {
                        this.live = true;
                        justLive = true;
                    }
                }
            }
            if (justLive) {
                SingleThreadInvoker.increaseLiveInvokerCount(this.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unused() {
            boolean justDead = false;
            Worker worker = this;
            synchronized (worker) {
                if (this.used) {
                    if (log.isDebug()) {
                        log.debug("unused invoker: " + this.name);
                    }
                    this.used = false;
                    this.unusedTime = System.currentTimeMillis();
                    if (this.live) {
                        this.live = false;
                        justDead = true;
                    }
                }
            }
            if (justDead) {
                SingleThreadInvoker.decreaseLiveInvokerCount(this.name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block58: {
                boolean justDead = false;
                try {
                    ArrayList arrayList = listeners;
                    synchronized (arrayList) {
                        activeWorkers.add(this);
                    }
                    String threadId = "SingleThreadInvoker" + (this.name == null ? "" : "('" + this.name + "')");
                    if (log.isInfo()) {
                        log.info(threadId + " has started");
                    }
                    ThreadHeartbeatCounter monitor = null;
                    try {
                        monitor = ThreadHeartbeatCounter.createThreadHeartbeatCounter(threadId, 1);
                        monitor.initialize();
                    }
                    catch (Exception e1) {
                        log.error("Exception while creating thread monitor", e1);
                    }
                    block29: while (true) {
                        while (!this.disposed) {
                            if (monitor != null) {
                                monitor.alive();
                            }
                            try {
                                long timeout = 500L;
                                Worker worker = this;
                                synchronized (worker) {
                                    if (!this.used) {
                                        timeout = Math.max(1L, timeout - (long)((int)(System.currentTimeMillis() - this.unusedTime)));
                                    }
                                }
                                Runnable task = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
                                if (monitor != null) {
                                    monitor.alive();
                                }
                                if (task != null && task != releaseMarker) {
                                    task.run();
                                    continue block29;
                                }
                                boolean needStopAprovement = false;
                                Worker worker2 = this;
                                synchronized (worker2) {
                                    if (this.queue.isEmpty()) {
                                        if (!this.released) {
                                            if (this.invokerRefQueue.poll() != null) {
                                                this.invokerRef.clear();
                                                if (log.isDebug()) {
                                                    log.debug("stopping invoker: " + this.name + " (no strong reference)");
                                                }
                                                if (this.live) {
                                                    this.live = false;
                                                    justDead = true;
                                                }
                                                this.disposed = true;
                                                break block58;
                                            }
                                            if (this.invokerRef.get() == null) {
                                                if (log.isDebug()) {
                                                    log.debug("stopping invoker: " + this.name + " (no strong reference)");
                                                }
                                                if (this.live) {
                                                    this.live = false;
                                                    justDead = true;
                                                }
                                                this.disposed = true;
                                                break block58;
                                            }
                                        }
                                        if (!this.released) {
                                            boolean flagReleaseMarker;
                                            boolean bl = flagReleaseMarker = task == releaseMarker;
                                            if (!this.used && (flagReleaseMarker || System.currentTimeMillis() - this.unusedTime > 500L)) {
                                                if (this.handler == null) {
                                                    if (log.isDebug()) {
                                                        if (flagReleaseMarker) {
                                                            log.debug("stopping invoker thread: " + this.name + " (shutdown)");
                                                        } else {
                                                            log.debug("stopping invoker thread: " + this.name + " (after inactivity)");
                                                        }
                                                    }
                                                    this.thread = null;
                                                    break block58;
                                                }
                                                if (this.handler != null) {
                                                    needStopAprovement = true;
                                                }
                                            }
                                        }
                                        if (this.released) {
                                            if (log.isDebug()) {
                                                log.debug("stopping invoker thread: " + this.name + " (was released)");
                                            }
                                            this.thread = null;
                                            break block58;
                                        }
                                    }
                                }
                                if (!needStopAprovement || !this.handler.onUnusedInvokerQueueTimout(this.name)) continue block29;
                                this.handler = null;
                                worker2 = this;
                                synchronized (worker2) {
                                    if (this.queue.isEmpty()) {
                                        if (log.isDebug()) {
                                            log.debug("stopping invoker thread: " + this.name + " (after inactivity)");
                                        }
                                        this.thread = null;
                                        break block58;
                                    }
                                    continue block29;
                                }
                            }
                            catch (InterruptedException e) {
                                log.debug("Interrupted invoker: " + this.name);
                            }
                            catch (Throwable e) {
                                log.warn("Unhandled exception in AsyncInvoker", e);
                            }
                        }
                        break block58;
                        {
                            continue block29;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (monitor != null) {
                            monitor.unregister();
                        }
                    }
                }
                finally {
                    Object[] theListeners = null;
                    ArrayList arrayList = listeners;
                    synchronized (arrayList) {
                        if (justDead) {
                            liveInvokerCount.decrementAndGet();
                        }
                        activeWorkers.remove(this);
                        if (activeWorkers.size() == 0 && liveInvokerCount.get() == 0 && listeners.size() > 0) {
                            theListeners = listeners.toArray();
                            listeners.clear();
                        }
                    }
                    SingleThreadInvoker.notifyAllStopped(theListeners);
                }
            }
        }
    }
}

