/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.util;

import java.util.Vector;

public class CallstackUtils {
    public static void upgradeCallstack(Throwable exception) {
        StackTraceElement[] stInner = exception.getStackTrace();
        exception.fillInStackTrace();
        StackTraceElement[] stOuter = exception.getStackTrace();
        int lenInner = stInner == null ? 0 : stInner.length;
        int lenOuter = stOuter == null ? 0 : stOuter.length;
        StackTraceElement[] stNew = new StackTraceElement[lenOuter + lenInner];
        if (lenOuter > 0) {
            System.arraycopy(stOuter, 1, stNew, 0, lenOuter - 1);
            stNew[lenOuter - 1] = new StackTraceElement("..", "throw", "", -1);
        }
        if (lenInner > 0) {
            System.arraycopy(stInner, 0, stNew, lenOuter, lenInner);
        }
        exception.setStackTrace(stNew);
    }

    public static String getCallstackInfo() {
        StringBuilder sb = new StringBuilder(8192);
        CallstackUtils.appendCallstackInfo(sb, Thread.currentThread().getStackTrace(), 2);
        return sb.toString();
    }

    public static String getCallstackInfo(int ignoreLevels) {
        StringBuilder sb = new StringBuilder(8192);
        CallstackUtils.appendCallstackInfo(sb, Thread.currentThread().getStackTrace(), ignoreLevels + 1);
        return sb.toString();
    }

    public static String getCallstackInfo(StackTraceElement[] elements) {
        StringBuilder sb = new StringBuilder(8192);
        CallstackUtils.appendCallstackInfo(sb, elements, 0);
        return sb.toString();
    }

    public static String getCallstackInfo(Throwable e) {
        return CallstackUtils.getCallstackInfo(e, 0);
    }

    public static String getCallstackInfo(Throwable e, int ignoreLevels) {
        Vector<Throwable> used = new Vector<Throwable>();
        StringBuilder sb = new StringBuilder(8192);
        while (e != null) {
            used.add(e);
            String message = e.getMessage();
            sb.append(e.getClass().getName() + ": " + (message != null ? message : "") + "\n");
            CallstackUtils.appendCallstackInfo(sb, e.getStackTrace(), ignoreLevels);
            ignoreLevels = 0;
            e = e.getCause();
            if (e == null || used.contains(e)) break;
            sb.append("Caused by: ");
        }
        return sb.toString();
    }

    public static void appendCallstackInfo(StringBuilder sb, StackTraceElement[] elements, int ignoreLevels) {
        for (StackTraceElement e : elements) {
            if (ignoreLevels-- > 0) continue;
            sb.append("       at ");
            sb.append(e.getClassName());
            sb.append('.');
            sb.append(e.getMethodName());
            sb.append('(');
            sb.append(e.getFileName());
            sb.append(':');
            sb.append(e.getLineNumber());
            sb.append(") ");
            if (e.isNativeMethod()) {
                sb.append(" [native]");
            }
            sb.append('\n');
        }
    }

    public static StackTraceElement getStackElementBeforeLog() {
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            if (stack != null) {
                boolean lookingForLogger = true;
                for (int ix = 2; ix < stack.length; ++ix) {
                    StackTraceElement elem = stack[ix];
                    String cname = elem.getClassName();
                    if (lookingForLogger) {
                        if (!CallstackUtils.isLoggerImpl(cname)) continue;
                        lookingForLogger = false;
                        continue;
                    }
                    if (CallstackUtils.isLoggerImpl(cname)) continue;
                    return elem;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isLoggerImpl(String classname) {
        return classname.endsWith(".Log$WrappedLogger");
    }
}

