/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.util;

import com.genesyslab.platform.commons.util.CompareUtils;
import java.util.HashMap;
import java.util.Map;

public class DeepHashMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = -5162718291833023919L;

    public DeepHashMap() {
    }

    public DeepHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public DeepHashMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    public DeepHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    public boolean equals(Object o) {
        int count2;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        int count = CompareUtils.notNullCount(this.values());
        if (count != (count2 = CompareUtils.notNullCount(m.values()))) {
            return false;
        }
        for (Map.Entry e : this.entrySet()) {
            Object value2;
            Object key = e.getKey();
            Object value = e.getValue();
            if (value == null ^ (value2 = m.get(key)) == null) {
                return false;
            }
            if (CompareUtils.deepEquals(value, value2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = DeepHashMap.class.hashCode();
        for (Map.Entry e : this.entrySet()) {
            h += 31 * CompareUtils.deepHashCode(e);
        }
        return h;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            return this.remove(key);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m.containsValue(null)) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (value == null) continue;
                this.put(key, value);
            }
        } else {
            super.putAll(m);
        }
    }

    public V putNullValue(K key) {
        return super.put(key, null);
    }

    public void putAbsolutlyAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
    }
}

