/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.timer.impl;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.SingleThreadInvoker;
import com.genesyslab.platform.commons.threading.ThreadHeartbeatCounter;
import com.genesyslab.platform.commons.timer.Scheduler;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import com.genesyslab.platform.commons.timer.impl.ImmidiateExecutionOnShutdown;
import java.util.ArrayList;
import java.util.Timer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SchedulerImpl
implements Scheduler {
    private static final int AUTO_UNLOAD_TIME = Math.max(0, PsdkCustomization.getIntOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.PsdkTimerShutdownDelay, (Integer)0));
    private static final ILogger log = Log.getLogger(SchedulerImpl.class);
    private static final ArrayList<Runnable> listeners = new ArrayList();
    private static final AtomicInteger incompleteActionCount = new AtomicInteger();
    private static final Vector<TimerAction> incompleteTasks = new Vector();
    private static final ArrayList<TimerTask> immediateExecutionOnShutdown = new ArrayList();
    private Timer timer = null;
    private ThreadHeartbeatCounter monitor = null;
    private final AtomicInteger externalTaskCounter = new AtomicInteger();
    private volatile long lastExternalActivityTime;

    public SchedulerImpl() {
        this.initialize();
    }

    private synchronized void initialize() {
        if (this.timer != null) {
            return;
        }
        if (log.isDebug()) {
            log.debug((Object)"Initialize PSDK-Timer");
        }
        this.timer = new Timer(true);
        this.timer.schedule(new java.util.TimerTask(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("PSDK.Timer");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 1L);
        try {
            this.monitor = ThreadHeartbeatCounter.createThreadHeartbeatCounter((String)"PSDKTimer", (int)1);
        }
        catch (Exception e) {
            log.error((Object)"Exception while creating thread monitor", (Throwable)e);
        }
        if (this.monitor != null) {
            this.timer.schedule(new java.util.TimerTask(){
                ThreadHeartbeatCounter monitorRef;
                {
                    this.monitorRef = SchedulerImpl.this.monitor;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SchedulerImpl schedulerImpl = SchedulerImpl.this;
                    synchronized (schedulerImpl) {
                        if (this.monitorRef == SchedulerImpl.this.monitor) {
                            SchedulerImpl.this.monitor.initialize();
                            SchedulerImpl.this.timer.schedule(new java.util.TimerTask(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    SchedulerImpl schedulerImpl = SchedulerImpl.this;
                                    synchronized (schedulerImpl) {
                                        if (monitorRef == SchedulerImpl.this.monitor) {
                                            SchedulerImpl.this.monitor.alive();
                                        }
                                    }
                                }
                            }, 10L, 500L);
                        }
                    }
                }
            }, 10L);
        }
        this.timer.schedule(new java.util.TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SchedulerImpl schedulerImpl = SchedulerImpl.this;
                synchronized (schedulerImpl) {
                    if (SchedulerImpl.this.externalTaskCounter.get() == 0 && System.currentTimeMillis() - SchedulerImpl.this.lastExternalActivityTime > (long)AUTO_UNLOAD_TIME && SingleThreadInvoker.getLiveInvokerCount() == 0) {
                        if (log.isDebug()) {
                            log.debug((Object)"Query for automatic shutdown PSDK-Timer due to inactivity");
                        }
                        SchedulerImpl.this.dispose();
                    }
                }
            }
        }, AUTO_UNLOAD_TIME, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSchedule(TimerTask task, long delay, long period, boolean retry) {
        boolean scheduled = false;
        SchedulerImpl schedulerImpl = this;
        synchronized (schedulerImpl) {
            boolean doRetry = retry;
            if (this.timer == null) {
                this.initialize();
                doRetry = false;
            }
            try {
                if (period > 0L) {
                    this.timer.schedule((java.util.TimerTask)task, delay, period);
                } else {
                    this.timer.schedule((java.util.TimerTask)task, delay);
                    if (task.action instanceof ImmidiateExecutionOnShutdown) {
                        ArrayList<TimerTask> arrayList = immediateExecutionOnShutdown;
                        synchronized (arrayList) {
                            immediateExecutionOnShutdown.add(task);
                        }
                    }
                }
                incompleteTasks.add(task.action);
                int counter = this.externalTaskCounter.incrementAndGet();
                if (log.isDebug()) {
                    if (period > 0L) {
                        log.debug((Object)("[PSDK.Timer] Scheduled " + task.action + "; delay:" + delay + "; period: " + period + "; queue:" + counter));
                    } else {
                        log.debug((Object)("[PSDK.Timer] Scheduled " + task.action + "; delay:" + delay + "; queue:" + counter));
                    }
                }
                scheduled = true;
            }
            catch (IllegalStateException ise) {
                if (doRetry) {
                    log.warn((Object)"Exception while task scheduling, recreating Timer", (Throwable)ise);
                    this.dispose();
                    this.initialize();
                    this.doSchedule(task, delay, period, false);
                }
                throw ise;
            }
        }
        if (scheduled && incompleteActionCount.incrementAndGet() == 0) {
            SchedulerImpl.notifyAllStopped(this);
        }
    }

    private synchronized void dispose() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.monitor != null) {
            this.monitor.forceUnregister();
            this.monitor = null;
        }
        if (log.isDebug()) {
            log.debug((Object)"Stop PSDK-Timer");
        }
    }

    @Override
    public TimerActionTicket schedule(long delay, TimerAction action) {
        TimerTask task = new TimerTask(action);
        TimerTicketImpl ticket = new TimerTicketImpl(task, action);
        this.doSchedule(task, delay, 0L, true);
        return ticket;
    }

    @Override
    public TimerActionTicket schedule(long delay, long period, TimerAction action) {
        TimerTask task = new TimerTask(action, period);
        TimerTicketImpl ticket = new TimerTicketImpl(task, action);
        this.doSchedule(task, delay, period, true);
        return ticket;
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyAllStopped(SchedulerImpl scheduler) {
        Object[] theListeners = null;
        ArrayList<Runnable> arrayList = listeners;
        synchronized (arrayList) {
            if (listeners.size() > 0) {
                theListeners = listeners.toArray();
                listeners.clear();
            }
        }
        if (theListeners != null && theListeners.length > 0) {
            if (log.isDebug()) {
                log.debug((Object)"All PSDK timer actions were executed.");
            }
            if (scheduler != null) {
                scheduler.dispose();
            }
            for (int i = 0; i < theListeners.length; ++i) {
                Runnable listener = (Runnable)theListeners[i];
                try {
                    listener.run();
                    continue;
                }
                catch (Throwable e) {
                    if (!log.isError()) continue;
                    log.error((Object)("Error in PSDK timer actions completion handler " + listener), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void awaitTermination(Runnable onCompleted) {
        if (log.isDebug()) {
            log.debug((Object)("Wait for execution completion of PSDK timer actions (" + incompleteActionCount.get() + " / " + immediateExecutionOnShutdown.size() + ")"));
        }
        Object[] theTimerTasks = null;
        ArrayList<TimerTask> arrayList = immediateExecutionOnShutdown;
        synchronized (arrayList) {
            if (immediateExecutionOnShutdown.size() > 0) {
                theTimerTasks = immediateExecutionOnShutdown.toArray();
                immediateExecutionOnShutdown.clear();
            }
        }
        if (theTimerTasks != null && theTimerTasks.length > 0) {
            for (int i = 0; i < theTimerTasks.length; ++i) {
                TimerTask task;
                block17: {
                    task = (TimerTask)theTimerTasks[i];
                    if (log.isDebug()) {
                        log.debug((Object)("Immediate execution of timer action " + task.action));
                    }
                    try {
                        task.run();
                    }
                    catch (Throwable e) {
                        if (!log.isError()) break block17;
                        log.error((Object)("Error in timer action " + task.action), e);
                    }
                }
                task.cancel();
            }
        }
        boolean notifyImmediately = false;
        ArrayList<Runnable> arrayList2 = listeners;
        synchronized (arrayList2) {
            if (incompleteActionCount.get() == 0) {
                notifyImmediately = true;
            } else {
                listeners.add(onCompleted);
            }
        }
        if (notifyImmediately) {
            if (log.isDebug()) {
                log.debug((Object)"All PSDK timer actions were executed");
            }
            TimerFactory.getTimer().shutdown();
            onCompleted.run();
        }
    }

    @Deprecated
    public static String getStateInfo() {
        Object[] actions = incompleteTasks.toArray();
        if (actions != null && actions.length > 0) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("   Incomplete tasks: ");
            sb.append(actions.length);
            sb.append("\n");
            for (Object action : actions) {
                sb.append("      ");
                sb.append(action);
                sb.append("\n");
            }
            return sb.toString();
        }
        return "";
    }

    private static class TimerTicketImpl
    implements TimerActionTicket {
        private TimerTask task;
        private TimerAction action;

        public TimerTicketImpl(TimerTask task, TimerAction action) {
            this.task = task;
            this.action = action;
        }

        @Override
        public void cancel() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    private class TimerTask
    extends java.util.TimerTask {
        private final TimerAction action;
        private final boolean singleExecution;
        private volatile boolean executed;
        private boolean taskStopped;
        private AtomicBoolean singleExecutionProtection = new AtomicBoolean();

        public TimerTask(TimerAction action) {
            this(action, 0L);
        }

        public TimerTask(TimerAction action, long period) {
            this.action = action;
            this.singleExecution = period <= 0L;
        }

        @Override
        public void run() {
            try {
                if (this.singleExecution && !this.singleExecutionProtection.compareAndSet(false, true)) {
                    return;
                }
                this.executed = true;
                if (this.action != null) {
                    this.action.onTimer();
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Exception in TimerAction", e);
            }
            if (this.singleExecution) {
                this.stopped();
            }
        }

        @Override
        public boolean cancel() {
            boolean cancel_result = super.cancel();
            this.stopped();
            return cancel_result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopped() {
            boolean justStopped = false;
            TimerTask timerTask = this;
            synchronized (timerTask) {
                if (!this.taskStopped) {
                    this.taskStopped = true;
                    justStopped = true;
                    incompleteTasks.remove(this.action);
                    int counter = SchedulerImpl.this.externalTaskCounter.decrementAndGet();
                    SchedulerImpl.this.lastExternalActivityTime = System.currentTimeMillis();
                    if (log.isDebug()) {
                        if (this.executed) {
                            log.debug((Object)("[PSDK.Timer] Completed task: " + this.action + "; queue:" + counter));
                        } else {
                            log.debug((Object)("[PSDK.Timer] Canceled task: " + this.action + "; queue:" + counter));
                        }
                    }
                    if (this.singleExecution && this.action instanceof ImmidiateExecutionOnShutdown) {
                        ArrayList arrayList = immediateExecutionOnShutdown;
                        synchronized (arrayList) {
                            immediateExecutionOnShutdown.remove(this);
                        }
                    }
                }
            }
            if (justStopped && incompleteActionCount.decrementAndGet() == 0) {
                SchedulerImpl.notifyAllStopped(SchedulerImpl.this);
            }
        }
    }
}

