/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import com.genesyslab.platform.reporting.protocol.runtime.ActionsMaskCodec;
import com.genesyslab.platform.reporting.protocol.statserver.ActionsMask;
import java.io.IOException;

class ActionsMaskDeserializer
extends JsonDeserializer<ActionsMask> {
    ActionsMaskDeserializer() {
    }

    public ActionsMask deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ActionsMask amask;
        JsonNode nodeBitmask;
        String jsonKey_ValueType = "$class";
        String jsonKey_Value = PSDKJSONConstants.getJSONKeyForValue(ctxt.getConfig().getPropertyNamingStrategy());
        JsonNode tree = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode nodeType = tree.get(jsonKey_ValueType);
        if (nodeType == null) {
            nodeType = tree.get(PSDKJSONConstants.getJSONKeyForValueType(ctxt.getConfig().getPropertyNamingStrategy()));
        }
        if ((nodeBitmask = tree.get(jsonKey_Value)) == null) {
            nodeBitmask = tree.get("bitmask");
        }
        if (nodeType == null || nodeType.isNull()) {
            throw new JsonParseException("Expected ActionMask '" + jsonKey_ValueType + "' attribute", jp.getCurrentLocation());
        }
        String type = nodeType.asText();
        if (type == null || type.length() == 0) {
            throw new JsonParseException("Expected not empty ActionMask '" + jsonKey_ValueType + "' attribute", jp.getCurrentLocation());
        }
        if (type.startsWith(".")) {
            type = type.substring(1);
        }
        if ((amask = ActionsMaskCodec.create((String)type)) == null) {
            throw new JsonParseException("Unknown ActionMask type: " + type, jp.getCurrentLocation());
        }
        if (nodeBitmask != null && !nodeBitmask.isNull()) {
            byte[] bits = nodeBitmask.binaryValue();
            amask.fromBitArray(bits);
        }
        return amask;
    }
}

