/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import com.genesyslab.platform.webmedia.protocol.basicchat.BasicChatEventList;
import com.genesyslab.platform.webmedia.protocol.basicchat.runtime.codec.BasicChatEventListCodec;
import java.io.IOException;

class BasicChatEventListSerializer
extends JsonSerializer<BasicChatEventList> {
    BasicChatEventListSerializer() {
    }

    public void serialize(BasicChatEventList value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value == null) {
            return;
        }
        ObjectMapper m = (ObjectMapper)jgen.getCodec();
        jgen.writeStartArray();
        PropertyNamingStrategy propertyNamingStrategy = provider.getConfig().getPropertyNamingStrategy();
        String JSONKey_value = PSDKJSONConstants.getJSONKeyForValue(propertyNamingStrategy);
        for (Object item : value) {
            jgen.writeStartObject();
            String eventType = BasicChatEventListCodec.getType(item.getClass());
            if (eventType == null) {
                throw new JsonGenerationException("Unsupported basic chat event type: " + item.getClass().getName());
            }
            jgen.writeStringField("$class", eventType);
            jgen.writeObjectField(JSONKey_value, item);
            jgen.writeEndObject();
        }
        jgen.writeEndArray();
    }
}

