/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObjectDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBase;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectDelta;
import com.genesyslab.platform.json.jackson2.ConfObjectDeserializer;
import com.genesyslab.platform.json.jackson2.MetaDataSupport;
import java.io.IOException;

class ConfObjectDeltaDeserializer
extends JsonDeserializer<ConfObjectDelta> {
    private MetaDataSupport metadataSupport;

    public ConfObjectDeltaDeserializer(MetaDataSupport metadataSupport) {
        this.metadataSupport = metadataSupport;
    }

    public ConfObjectDelta deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
            throw new JsonParseException("Expected object start token", jp.getCurrentLocation());
        }
        ObjectCodec codec = jp.getCodec();
        JsonNode node = (JsonNode)codec.readTree(jp);
        CfgMetadata metadata = this.metadataSupport.getMetadata();
        if (metadata == null) {
            throw new JsonParseException("Not defined metadata", jp.getCurrentLocation());
        }
        ConfObjectDelta cobj = new ConfObjectDelta(ConfObjectDeserializer.readDescription(codec, node, metadata, CfgDescriptionObjectDelta.class));
        ConfObjectDeserializer.deserializeObj(codec, ctxt, (ConfObjectBase)cobj, node, metadata);
        return cobj;
    }
}

