/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeEnumItem;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionEnum;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.obj.ConfIntegerCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBase;
import com.genesyslab.platform.configuration.protocol.obj.ConfStringCollection;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructure;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructureCollection;
import com.genesyslab.platform.json.jackson2.MetaDataSupport;
import java.io.IOException;
import java.sql.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

class ConfObjectDeserializer
extends JsonDeserializer<ConfObject> {
    private MetaDataSupport metadataSupport;

    public ConfObjectDeserializer(MetaDataSupport metadataSupport) {
        this.metadataSupport = metadataSupport;
    }

    public ConfObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
            throw new JsonParseException("Expected object start token", jp.getCurrentLocation());
        }
        ObjectCodec codec = jp.getCodec();
        JsonNode nodeCfgObject = (JsonNode)codec.readTree(jp);
        CfgMetadata metadata = this.metadataSupport.getMetadata();
        if (metadata == null) {
            throw new JsonParseException("Not defined metadata", jp.getCurrentLocation());
        }
        ConfObject cobj = new ConfObject(ConfObjectDeserializer.readDescription(codec, nodeCfgObject, metadata, CfgDescriptionObject.class));
        ConfObjectDeserializer.deserializeObj(codec, ctxt, (ConfObjectBase)cobj, nodeCfgObject, metadata);
        return cobj;
    }

    private static JsonLocation getCurrentLocation(ObjectCodec codec, JsonNode node) {
        return codec.treeAsTokens((TreeNode)node).getCurrentLocation();
    }

    static void deserializeObj(ObjectCodec codec, DeserializationContext ctxt, ConfObjectBase cobj, JsonNode nodeObject, CfgMetadata metadata) throws JsonProcessingException, IOException {
        block7: {
            CfgDescriptionClass classInfo;
            boolean failOnUnknownProperties;
            PropertyNamingStrategy.PropertyNamingStrategyBase pnsb;
            block6: {
                boolean jsonHasLessPropertiesThenClassInfo;
                PropertyNamingStrategy pns = ctxt.getConfig().getPropertyNamingStrategy();
                pnsb = pns instanceof PropertyNamingStrategy.PropertyNamingStrategyBase ? (PropertyNamingStrategy.PropertyNamingStrategyBase)pns : null;
                failOnUnknownProperties = ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                classInfo = cobj.getClassInfo();
                boolean bl = jsonHasLessPropertiesThenClassInfo = classInfo.getAttributes().size() > nodeObject.size() - 1;
                if (pnsb != null || !jsonHasLessPropertiesThenClassInfo) break block6;
                Iterator it = nodeObject.fields();
                while (it.hasNext()) {
                    Map.Entry entity = (Map.Entry)it.next();
                    String key = (String)entity.getKey();
                    if ("$class".equals(key)) continue;
                    CfgDescriptionAttribute attr = classInfo.getAttribute(key);
                    if (attr == null) {
                        ctxt.reportUnknownProperty((Object)cobj, key, null);
                        continue;
                    }
                    JsonNode node = (JsonNode)entity.getValue();
                    ConfObjectDeserializer.deserializeProperty(codec, ctxt, cobj, attr, node, metadata);
                }
                break block7;
            }
            IdentityHashMap processedNodes = failOnUnknownProperties ? new IdentityHashMap() : null;
            for (CfgDescriptionAttribute attr : classInfo.getAttributes()) {
                JsonNode node;
                String schemaName;
                String jsonKey = schemaName = attr.getSchemaName();
                if (pnsb != null) {
                    jsonKey = pnsb.translate(jsonKey);
                }
                if ((node = nodeObject.get(jsonKey)) == null) continue;
                if (processedNodes != null) {
                    processedNodes.put(node, null);
                }
                ConfObjectDeserializer.deserializeProperty(codec, ctxt, cobj, attr, node, metadata);
            }
            if (processedNodes == null) break block7;
            Iterator it = nodeObject.fields();
            while (it.hasNext()) {
                String key;
                Map.Entry entity = (Map.Entry)it.next();
                if (processedNodes.containsKey(entity.getValue()) || "$class".equals(key = (String)entity.getKey())) continue;
                ctxt.reportUnknownProperty((Object)cobj, key, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void deserializeProperty(ObjectCodec codec, DeserializationContext ctxt, ConfObjectBase cobj, CfgDescriptionAttribute attr, JsonNode node, CfgMetadata metadata) throws JsonProcessingException, IOException {
        if (node.isNull()) {
            cobj.setPropertyValue(attr.getIndex(), null);
            return;
        }
        if (attr.isCfgType(CfgTypeMask.Primitive)) {
            if (attr.isCfgType(CfgTypeMask.Time)) {
                cobj.setPropertyValue(attr.getIndex(), (Object)((int)(((Date)codec.treeToValue((TreeNode)node, Date.class)).getTime() / 1000L)));
                return;
            } else if (attr.isCfgType(CfgTypeMask.Enum)) {
                CfgDescriptionEnum enumDesc = ((CfgDescriptionAttributeEnumItem)attr).getEnumDescription();
                Class classEnum = enumDesc.getCfgEnumClass();
                if (node.isInt()) {
                    int ordinal = node.asInt();
                    cobj.setPropertyValue(attr.getIndex(), (Object)ordinal);
                    return;
                } else {
                    if (!node.isTextual()) return;
                    String name = node.asText();
                    GEnum v = GEnum.getValue((Class)classEnum, (String)name);
                    if (v == null) throw new JsonParseException("Unknown enum value '" + name + "' for " + classEnum.getSimpleName(), ConfObjectDeserializer.getCurrentLocation(codec, node));
                    cobj.setPropertyValue(attr.getIndex(), (Object)v);
                }
                return;
            } else if (attr.isCfgType(CfgTypeMask.Integer)) {
                cobj.setPropertyValue(attr.getIndex(), (Object)node.asInt());
                return;
            } else {
                if (!attr.isCfgType(CfgTypeMask.String)) throw new JsonParseException("Unexpected type while deserializing ConfObject. " + attr.getTypeMaskString(), ConfObjectDeserializer.getCurrentLocation(codec, node));
                cobj.setPropertyValue(attr.getIndex(), (Object)node.asText());
            }
            return;
        } else if (attr.isCfgType(CfgTypeMask.List)) {
            if (attr.isCfgType(CfgTypeMask.KvList)) {
                KeyValueCollection kv = (KeyValueCollection)codec.treeToValue((TreeNode)node, KeyValueCollection.class);
                cobj.setPropertyValue(attr.getIndex(), (Object)kv);
                return;
            } else if (attr.isCfgType(CfgTypeMask.Structure)) {
                ConfStructureCollection col = (ConfStructureCollection)cobj.getOrCreatePropertyValue(attr.getSchemaName());
                Iterator it = node.elements();
                while (it.hasNext()) {
                    JsonNode nodeItem = (JsonNode)it.next();
                    ConfStructure item = col.createStructure();
                    ConfObjectDeserializer.deserializeObj(codec, ctxt, (ConfObjectBase)item, nodeItem, metadata);
                    col.add((Object)item);
                }
                return;
            } else if (attr.isCfgType(CfgTypeMask.Integer)) {
                ConfIntegerCollection col = (ConfIntegerCollection)cobj.getOrCreatePropertyValue(attr.getSchemaName());
                Iterator it = node.elements();
                while (it.hasNext()) {
                    JsonNode nodeItem = (JsonNode)it.next();
                    col.add((Object)nodeItem.asInt());
                }
                return;
            } else if (attr.isCfgType(CfgTypeMask.String)) {
                ConfStringCollection col = (ConfStringCollection)cobj.getOrCreatePropertyValue(attr.getSchemaName());
                Iterator it = node.elements();
                while (it.hasNext()) {
                    JsonNode nodeItem = (JsonNode)it.next();
                    col.add((Object)nodeItem.asText());
                }
                return;
            } else {
                if (!attr.isCfgType(CfgTypeMask.Link)) throw new JsonParseException("Unexpected type while deserializing ConfObject. " + attr.getTypeMaskString(), ConfObjectDeserializer.getCurrentLocation(codec, node));
                ConfIntegerCollection col = (ConfIntegerCollection)cobj.getOrCreatePropertyValue(attr.getSchemaName());
                Iterator it = node.elements();
                while (it.hasNext()) {
                    JsonNode nodeValue = (JsonNode)it.next();
                    col.add((Object)nodeValue.asInt());
                }
            }
            return;
        } else if (attr.isCfgType(CfgTypeMask.Structure)) {
            ConfStructure item = new ConfStructure(ConfObjectDeserializer.readDescription(codec, node, metadata, CfgDescriptionStructure.class));
            ConfObjectDeserializer.deserializeObj(codec, ctxt, (ConfObjectBase)item, node, metadata);
            cobj.setPropertyValue(attr.getIndex(), (Object)item);
            return;
        } else if (attr.isCfgType(CfgTypeMask.Object)) {
            ConfObject item = new ConfObject(ConfObjectDeserializer.readDescription(codec, node, metadata, CfgDescriptionObject.class));
            ConfObjectDeserializer.deserializeObj(codec, ctxt, (ConfObjectBase)item, node, metadata);
            cobj.setPropertyValue(attr.getIndex(), (Object)item);
            return;
        } else {
            if (!attr.isCfgType(CfgTypeMask.Link)) throw new JsonParseException("Unexpected type while deserializing ConfObject. " + attr.getTypeMaskString(), ConfObjectDeserializer.getCurrentLocation(codec, node));
            cobj.setPropertyValue(attr.getIndex(), (Object)node.asInt());
        }
    }

    static <T extends CfgDescription> T readDescription(ObjectCodec codec, JsonNode node, CfgMetadata metadata, Class<T> classType) throws JsonParseException {
        JsonNode nodeClass = node.get("$class");
        if (nodeClass == null) {
            throw new JsonParseException("Expected '$class' property", ConfObjectDeserializer.getCurrentLocation(codec, node));
        }
        String className = nodeClass.textValue();
        if (className == null || className.length() == 0) {
            throw new JsonParseException("Expected non empty '$class' property", ConfObjectDeserializer.getCurrentLocation(codec, node));
        }
        CfgDescriptionClass result = metadata.getCfgClass(className);
        if (result == null) {
            throw new JsonParseException("Unknown config class: " + className, ConfObjectDeserializer.getCurrentLocation(codec, node));
        }
        if (!classType.isInstance(result)) {
            throw new JsonParseException("It isn't expected class: " + result.getClass().getSimpleName() + " expected: " + classType.getSimpleName(), ConfObjectDeserializer.getCurrentLocation(codec, node));
        }
        return (T)result;
    }
}

