/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBase;
import com.genesyslab.platform.configuration.protocol.obj.ConfStructure;
import com.genesyslab.platform.json.jackson2.ConfObjectDeserializer;
import com.genesyslab.platform.json.jackson2.MetaDataSupport;
import java.io.IOException;

class ConfStructureDeserializer
extends JsonDeserializer<ConfStructure> {
    private MetaDataSupport metadataSupport;

    public ConfStructureDeserializer(MetaDataSupport metadataSupport) {
        this.metadataSupport = metadataSupport;
    }

    public ConfStructure deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
            throw new JsonParseException("Expected object start token", jp.getCurrentLocation());
        }
        ObjectMapper codec = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        CfgMetadata metadata = this.metadataSupport.getMetadata();
        if (metadata == null) {
            throw new JsonParseException("Not defined metadata", jp.getCurrentLocation());
        }
        ConfStructure cobj = new ConfStructure(ConfObjectDeserializer.readDescription((ObjectCodec)codec, node, metadata, CfgDescriptionStructure.class));
        ConfObjectDeserializer.deserializeObj(jp.getCodec(), ctxt, (ConfObjectBase)cobj, node, metadata);
        return cobj;
    }
}

