/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.genesyslab.platform.commons.connection.AttributeRawValue;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParser;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.DefaultPropertyNamingStrategy;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

final class DataSupportSerializer
extends JsonSerializer<DataSupport> {
    private boolean enabledMessageNameSerialization;

    public DataSupportSerializer(boolean enabledMessageNameSerialization) {
        this.enabledMessageNameSerialization = enabledMessageNameSerialization;
    }

    public void serialize(DataSupport value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        PropertyNamingStrategy.PropertyNamingStrategyBase nsb;
        if (value == null) {
            return;
        }
        jgen.writeStartObject();
        SerializationConfig cfg = provider.getConfig();
        PropertyNamingStrategy ns = cfg.getPropertyNamingStrategy();
        PropertyNamingStrategy.PropertyNamingStrategyBase propertyNamingStrategyBase = nsb = ns instanceof PropertyNamingStrategy.PropertyNamingStrategyBase ? (PropertyNamingStrategy.PropertyNamingStrategyBase)ns : null;
        if (value instanceof Message) {
            String name;
            Message msg = (Message)value;
            if (this.enabledMessageNameSerialization) {
                name = "messageName";
                if (nsb != null) {
                    name = nsb.translate(name);
                } else if (name.length() > 0) {
                    name = DefaultPropertyNamingStrategy.translate(name);
                }
                jgen.writeStringField(name, msg.messageName());
            }
            if (value instanceof ProtocolUnknownMessage) {
                name = "messageId";
                if (nsb != null) {
                    name = nsb.translate(name);
                } else if (name.length() > 0) {
                    name = DefaultPropertyNamingStrategy.translate(name);
                }
                jgen.writeNumberField(name, msg.messageId());
            }
        }
        this.writeAttributes(value, jgen, nsb);
        this.writeCompounds(value, jgen, nsb);
        jgen.writeEndObject();
    }

    private void writeCompounds(DataSupport ds, JsonGenerator jgen, PropertyNamingStrategy.PropertyNamingStrategyBase nsb) throws IOException {
        Set compounds = ds.getCompounds().entrySet();
        for (Map.Entry compound : compounds) {
            Object key;
            Object value = compound.getValue();
            if (value == null || !((key = compound.getKey()) instanceof String)) continue;
            String skey = (String)key;
            Class<?> sclass = ds.getClass().getSuperclass();
            try {
                sclass.getMethod("get" + skey, null);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            String name = skey;
            if (nsb != null) {
                name = nsb.translate(name);
            } else if (name.length() > 0) {
                name = DefaultPropertyNamingStrategy.translate(name);
            }
            jgen.writeObjectField(name, value);
        }
    }

    private void writeAttributes(DataSupport ds, JsonGenerator jgen, PropertyNamingStrategy.PropertyNamingStrategyBase nsb) throws IOException {
        Set attrs = ds.attributes().entrySet();
        MetaData meta = ds.getMetaData();
        block0: for (Map.Entry entry : attrs) {
            CodecLazyParser lazyParser;
            Object key;
            Object value = entry.getValue();
            if (value == null || !((key = entry.getKey()) instanceof String)) continue;
            String skey = (String)key;
            boolean keyIsEqualsAttributeDescriptionId = false;
            AttributeDescription ad = meta.getAttributeDescription((Object)skey);
            if (ad != null) {
                boolean bl = keyIsEqualsAttributeDescriptionId = !skey.equals(ad.getName());
                if (ad.isSerializationHidden() || ad.isHidden()) continue;
            }
            String name = skey;
            if (nsb != null) {
                name = nsb.translate(name);
            } else if (name.length() > 0) {
                name = DefaultPropertyNamingStrategy.translate(name);
            }
            if (value == null && (lazyParser = ds.getLazyParser()).hasAttribute(skey)) {
                if (Document.class.isAssignableFrom(ad.getValueType())) continue;
                lazyParser.parse(skey);
                value = entry.getValue();
            }
            if (ad != null && !keyIsEqualsAttributeDescriptionId) {
                jgen.writeObjectField(name, value);
                continue;
            }
            if (!keyIsEqualsAttributeDescriptionId) {
                for (int i = skey.length() - 1; i >= 0; --i) {
                    char c = skey.charAt(i);
                    if (c < '0' || c > '9') continue block0;
                }
            }
            Object sType = null;
            Class<?> vc = value.getClass();
            if (vc == byte[].class) {
                jgen.writeFieldName(skey);
                jgen.writeStartObject();
                jgen.writeStringField(PSDKJSONConstants.getJSONKeyForValueType((PropertyNamingStrategy)nsb), "b");
                jgen.writeBinaryField(PSDKJSONConstants.getJSONKeyForValue((PropertyNamingStrategy)nsb), (byte[])value);
                jgen.writeEndObject();
                continue;
            }
            if (vc == Integer.class) {
                jgen.writeFieldName(skey);
                jgen.writeStartObject();
                jgen.writeStringField(PSDKJSONConstants.getJSONKeyForValueType((PropertyNamingStrategy)nsb), "i");
                jgen.writeNumberField(PSDKJSONConstants.getJSONKeyForValue((PropertyNamingStrategy)nsb), ((Integer)value).intValue());
                jgen.writeEndObject();
                continue;
            }
            if (vc == Long.class) {
                jgen.writeFieldName(skey);
                jgen.writeStartObject();
                jgen.writeStringField(PSDKJSONConstants.getJSONKeyForValueType((PropertyNamingStrategy)nsb), "l");
                jgen.writeNumberField(PSDKJSONConstants.getJSONKeyForValue((PropertyNamingStrategy)nsb), ((Long)value).longValue());
                jgen.writeEndObject();
                continue;
            }
            if (vc == String.class) {
                jgen.writeFieldName(skey);
                jgen.writeStartObject();
                jgen.writeStringField(PSDKJSONConstants.getJSONKeyForValueType((PropertyNamingStrategy)nsb), "s");
                jgen.writeStringField(PSDKJSONConstants.getJSONKeyForValue((PropertyNamingStrategy)nsb), (String)value);
                jgen.writeEndObject();
                continue;
            }
            if (vc != AttributeRawValue.class) continue;
            AttributeRawValue arv = (AttributeRawValue)value;
            jgen.writeFieldName(skey);
            jgen.writeStartObject();
            jgen.writeStringField(PSDKJSONConstants.getJSONKeyForValueType((PropertyNamingStrategy)nsb), "r" + arv.getType());
            jgen.writeBinaryField(PSDKJSONConstants.getJSONKeyForValue((PropertyNamingStrategy)nsb), arv.getData());
            jgen.writeEndObject();
        }
    }
}

