/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.genesyslab.platform.voice.protocol.EventMask;
import java.io.IOException;

class EventMaskDeserializer
extends JsonDeserializer<EventMask> {
    private char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    EventMaskDeserializer() {
    }

    public EventMask deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String mask = jp.getText();
        if (mask == null) {
            return null;
        }
        if ((mask = mask.trim()).length() != 128) {
            throw new JsonParseException("EventMask must be represented as 128 hex symbols. But it is " + mask, jp.getCurrentLocation());
        }
        mask = mask.toUpperCase();
        byte[] buf = new byte[64];
        int i = 0;
        while (i < 128) {
            char hex;
            int n = 0;
            int index = i >> 1;
            try {
                hex = mask.charAt(i++);
                n = EventMaskDeserializer.getHexNumber(hex) << 4;
                hex = mask.charAt(i++);
            }
            catch (IllegalArgumentException ex) {
                throw new JsonParseException("Illegal EventMask value: " + mask, jp.getCurrentLocation(), (Throwable)ex);
            }
            buf[index] = (byte)(n |= EventMaskDeserializer.getHexNumber(hex));
        }
        return new EventMask(buf, 0);
    }

    private static int getHexNumber(int hex) {
        if (hex >= 48 && hex <= 57) {
            return hex - 48;
        }
        if (hex >= 65 && hex <= 70) {
            return hex - 65 + 10;
        }
        throw new IllegalArgumentException("Illegal hex symbol: " + hex);
    }
}

