/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.contacts.protocol.contactserver.KeyValueObject;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import java.io.IOException;

class KeyValueObjectDeserializer
extends JsonDeserializer<KeyValueObject> {
    KeyValueObjectDeserializer() {
    }

    public KeyValueObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
            throw new JsonParseException("Expected start object for key value object", jp.getTokenLocation());
        }
        ObjectMapper m = (ObjectMapper)jp.getCodec();
        PropertyNamingStrategy pns = ctxt.getConfig().getPropertyNamingStrategy();
        String JsonKey_Value = PSDKJSONConstants.getJSONKeyForValue(pns);
        String JsonKey_ValueType = PSDKJSONConstants.getJSONKeyForValueType(pns);
        JsonNode nodeKVP = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode nodeType = nodeKVP.get(JsonKey_ValueType);
        JsonNode nodeValue = nodeKVP.get(JsonKey_Value);
        if (nodeValue == null) {
            throw new JsonParseException("KeyValueObject value is absent", jp.getTokenLocation());
        }
        if (nodeValue.isNull()) {
            throw new JsonParseException("KeyValueObject value is null", jp.getTokenLocation());
        }
        if (nodeType != null && !nodeType.isNull()) {
            String type = nodeType.textValue();
            if ("int".equals(type)) {
                return new KeyValueObject(nodeValue.intValue());
            }
            if ("str".equals(type)) {
                return new KeyValueObject(nodeValue.textValue());
            }
            if ("byte[]".equals(type)) {
                return new KeyValueObject(nodeValue.binaryValue());
            }
            if ("kvlist".equals(type)) {
                return new KeyValueObject((KeyValueCollection)m.treeToValue((TreeNode)nodeValue, KeyValueCollection.class));
            }
            throw new JsonParseException("Unknown KeyValueObject type: " + type, jp.getTokenLocation());
        }
        if (nodeValue.isInt()) {
            return new KeyValueObject(nodeValue.intValue());
        }
        if (nodeValue.isArray()) {
            return new KeyValueObject((KeyValueCollection)m.treeToValue((TreeNode)nodeValue, KeyValueCollection.class));
        }
        if (nodeValue.isTextual()) {
            return new KeyValueObject(nodeValue.textValue());
        }
        throw new JsonParseException("Unsupported KeyValuePair value: " + nodeValue.asText(), jp.getTokenLocation());
    }
}

