/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.genesyslab.platform.contacts.protocol.contactserver.KeyValueObject;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import java.io.IOException;

class KeyValueObjectSerializer
extends JsonSerializer<KeyValueObject> {
    KeyValueObjectSerializer() {
    }

    public void serialize(KeyValueObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value == null) {
            return;
        }
        PropertyNamingStrategy pns = provider.getConfig().getPropertyNamingStrategy();
        String JsonKey_Value = PSDKJSONConstants.getJSONKeyForValue(pns);
        String JsonKey_ValueType = PSDKJSONConstants.getJSONKeyForValueType(pns);
        jgen.writeStartObject();
        if (value.getIntegerValue() != null) {
            jgen.writeStringField(JsonKey_ValueType, "int");
            jgen.writeNumberField(JsonKey_Value, value.getIntegerValue().intValue());
        } else if (value.getStringValue() != null) {
            jgen.writeStringField(JsonKey_ValueType, "str");
            jgen.writeStringField(JsonKey_Value, value.getStringValue());
        } else if (value.getBinaryValue() != null) {
            jgen.writeStringField(JsonKey_ValueType, "byte[]");
            jgen.writeBinaryField(JsonKey_Value, value.getBinaryValue());
        } else if (value.getKeyValueCollection() != null) {
            jgen.writeStringField(JsonKey_ValueType, "kvlist");
            jgen.writeObjectField(JsonKey_Value, (Object)value.getKeyValueCollection());
        } else {
            throw new JsonGenerationException("Incorrect KeyValueObject value type", (Throwable)null);
        }
        jgen.writeEndObject();
    }
}

