/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import java.io.IOException;

class KeyValuePairDeserializer
extends JsonDeserializer<KeyValuePair> {
    KeyValuePairDeserializer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KeyValuePair deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
            throw new JsonParseException("Expected start object for key value pair", jp.getTokenLocation());
        }
        ObjectMapper m = (ObjectMapper)jp.getCodec();
        PropertyNamingStrategy pns = ctxt.getConfig().getPropertyNamingStrategy();
        String JsonKey_Key = PSDKJSONConstants.getJSONKeyForPairKey(pns);
        String JsonKey_Value = PSDKJSONConstants.getJSONKeyForValue(pns);
        String JsonKey_ValueType = PSDKJSONConstants.getJSONKeyForValueType(pns);
        JsonNode nodeKVP = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode nodeKey = nodeKVP.get(JsonKey_Key);
        JsonNode nodeType = nodeKVP.get(JsonKey_ValueType);
        JsonNode nodeValue = nodeKVP.get(JsonKey_Value);
        if (nodeKey == null) {
            throw new JsonParseException("KeyValuePair key '" + JsonKey_Key + "' is absent", jp.getTokenLocation());
        }
        String key = nodeKey.textValue();
        if (key == null) {
            throw new JsonParseException("KeyValuePair key '" + JsonKey_Key + "' is null", jp.getTokenLocation());
        }
        if (nodeValue == null) {
            throw new JsonParseException("KeyValuePair value '" + JsonKey_Value + "' is absent", jp.getTokenLocation());
        }
        if (nodeValue.isNull()) {
            throw new JsonParseException("KeyValuePair value '" + JsonKey_Value + "'  is null", jp.getTokenLocation());
        }
        KeyValuePair kvp = new KeyValuePair(key);
        if (nodeType != null && !nodeType.isNull()) {
            String type = nodeType.textValue();
            if ("int".equals(type)) {
                kvp.setIntValue(nodeValue.intValue());
                return kvp;
            } else if ("str".equals(type)) {
                kvp.setStringValue(nodeValue.textValue());
                return kvp;
            } else if ("utf".equals(type)) {
                kvp.setUTF16Value(nodeValue.textValue());
                return kvp;
            } else if ("byte[]".equals(type)) {
                kvp.setBinaryValue(nodeValue.binaryValue());
                return kvp;
            } else {
                if (!"kvlist".equals(type)) throw new JsonParseException("Unknown KeyValuePair type: " + type, jp.getTokenLocation());
                kvp.setTKVValue((KeyValueCollection)m.treeToValue((TreeNode)nodeValue, KeyValueCollection.class));
            }
            return kvp;
        } else if (nodeValue.isInt()) {
            kvp.setIntValue(nodeValue.intValue());
            return kvp;
        } else if (nodeValue.isArray()) {
            kvp.setTKVValue((KeyValueCollection)m.treeToValue((TreeNode)nodeValue, KeyValueCollection.class));
            return kvp;
        } else {
            if (!nodeValue.isTextual()) throw new JsonParseException("Unsupported KeyValuePair value: " + nodeValue.asText(), jp.getTokenLocation());
            kvp.setStringValue(nodeValue.textValue());
        }
        return kvp;
    }
}

