/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.collections.KVList;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.commons.collections.UTFValue;
import com.genesyslab.platform.commons.protocol.DataObject;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParser;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.DataObjectMixIn;
import com.genesyslab.platform.json.jackson2.DataSupportSerializer;
import com.genesyslab.platform.json.jackson2.GEnumMixIn;
import com.genesyslab.platform.json.jackson2.ISO8601DateFormatWithMilliseconds;
import com.genesyslab.platform.json.jackson2.IgnoreMixIn;
import com.genesyslab.platform.json.jackson2.KeyValueCollectionDeserializer;
import com.genesyslab.platform.json.jackson2.KeyValuePairDeserializer;
import com.genesyslab.platform.json.jackson2.MessageMixIn;
import com.genesyslab.platform.json.jackson2.MessageMixInWithMessageName;
import com.genesyslab.platform.json.jackson2.PSDKModuleConfigurator;
import com.genesyslab.platform.json.jackson2.PSDKModulesCustomization;
import com.genesyslab.platform.json.jackson2.PairMixIn;
import com.genesyslab.platform.json.jackson2.PairSerializer;
import com.genesyslab.platform.json.jackson2.ProtocolUnknownMessageMixIn;
import com.genesyslab.platform.json.jackson2.RawPropertyHandler;
import com.genesyslab.platform.json.jackson2.UTFValueMixIn;
import java.text.DateFormat;

public abstract class PSDKCommonModule
extends SimpleModule {
    private final PSDKModuleConfigurator customProtocolConfigurator;
    private final PSDKModuleConfigurator customCategoryConfigurator;
    protected final boolean enabledMessageNameSerialization;

    public PSDKCommonModule(String protocol, String category, Version version) {
        this(protocol, category, version, false);
    }

    public PSDKCommonModule(String protocol, String category, Version version, boolean enabledMessageNameSerialization) {
        super(protocol, version);
        this.enabledMessageNameSerialization = enabledMessageNameSerialization;
        this.customProtocolConfigurator = PSDKModulesCustomization.getProtocolConfigurator(protocol);
        this.customCategoryConfigurator = PSDKModulesCustomization.getCategoryConfigurator(category);
        if (this.customProtocolConfigurator != null) {
            this.customProtocolConfigurator.init(this);
        }
        if (this.customCategoryConfigurator != null) {
            this.customCategoryConfigurator.init(this);
        }
        this.addSerializer(Pair.class, new PairSerializer());
        this.addDeserializer(Pair.class, new KeyValuePairDeserializer());
        this.addDeserializer(KeyValuePair.class, new KeyValuePairDeserializer());
        this.addDeserializer(KeyValueCollection.class, new KeyValueCollectionDeserializer());
        this.addDeserializer(KVList.class, new KeyValueCollectionDeserializer());
        this.addSerializer(DataSupport.class, new DataSupportSerializer(enabledMessageNameSerialization));
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        if (this.customProtocolConfigurator != null) {
            this.customProtocolConfigurator.setup(context);
        }
        if (this.customCategoryConfigurator != null) {
            this.customCategoryConfigurator.setup(context);
        }
        ObjectMapper mapper = (ObjectMapper)context.getOwner();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setDateFormat((DateFormat)((Object)new ISO8601DateFormatWithMilliseconds()));
        mapper.addHandler((DeserializationProblemHandler)new RawPropertyHandler());
        context.setMixInAnnotations(ProtocolDescription.class, IgnoreMixIn.class);
        context.setMixInAnnotations(MetaData.class, IgnoreMixIn.class);
        context.setMixInAnnotations(CodecLazyParser.class, IgnoreMixIn.class);
        context.setMixInAnnotations(GEnum.class, GEnumMixIn.class);
        context.setMixInAnnotations(UTFValue.class, UTFValueMixIn.class);
        context.setMixInAnnotations(Message.class, this.enabledMessageNameSerialization ? MessageMixInWithMessageName.class : MessageMixIn.class);
        context.setMixInAnnotations(DataObject.class, DataObjectMixIn.class);
        context.setMixInAnnotations(Pair.class, PairMixIn.class);
        context.setMixInAnnotations(ProtocolUnknownMessage.class, ProtocolUnknownMessageMixIn.class);
    }

    protected static boolean isProtocolAvailable(String category, String protocol) {
        return PSDKModulesCustomization.isProtocolAvailable(category, protocol);
    }

    public Class<?> getMarkerClass() {
        return null;
    }

    public Class<? extends Message> getMessageClass(String name) {
        return null;
    }

    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return null;
    }
}

