/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.commons.collections.UTFValue;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import java.io.IOException;

class PairSerializer
extends JsonSerializer<Pair> {
    PairSerializer() {
    }

    public void serialize(Pair value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value == null) {
            return;
        }
        Object v = value.getValue();
        if (v == null) {
            throw new JsonGenerationException("null KeyValuePair value is unsupported", (Throwable)null);
        }
        PropertyNamingStrategy pns = provider.getConfig().getPropertyNamingStrategy();
        String JsonKey_Key = PSDKJSONConstants.getJSONKeyForPairKey(pns);
        String JsonKey_Value = PSDKJSONConstants.getJSONKeyForValue(pns);
        String JsonKey_ValueType = PSDKJSONConstants.getJSONKeyForValueType(pns);
        jgen.writeStartObject();
        jgen.writeStringField(JsonKey_Key, value.getStringKey());
        Class<?> c = v.getClass();
        if (c == Integer.class) {
            jgen.writeStringField(JsonKey_ValueType, "int");
        } else if (c == String.class) {
            jgen.writeStringField(JsonKey_ValueType, "str");
        } else if (c == byte[].class) {
            jgen.writeStringField(JsonKey_ValueType, "byte[]");
        } else if (c == UTFValue.class) {
            jgen.writeStringField(JsonKey_ValueType, "utf");
        } else if (c == KeyValueCollection.class) {
            jgen.writeStringField(JsonKey_ValueType, "kvlist");
        }
        jgen.writeObjectField(JsonKey_Value, v);
        jgen.writeEndObject();
    }
}

