/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.genesyslab.platform.commons.connection.AttributeRawValue;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.json.jackson2.PSDKJSONConstants;
import java.io.IOException;

final class RawPropertyHandler
extends DeserializationProblemHandler {
    RawPropertyHandler() {
    }

    public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
        if (RawPropertyHandler._handleUnknownProperty(ctxt, jp, deserializer, beanOrClass, propertyName)) {
            return true;
        }
        return super.handleUnknownProperty(ctxt, jp, deserializer, beanOrClass, propertyName);
    }

    static boolean _handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
        block34: {
            PropertyNamingStrategy.PropertyNamingStrategyBase nsb;
            boolean ignoreUnknown = !ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            PropertyNamingStrategy ns = ctxt.getConfig().getPropertyNamingStrategy();
            PropertyNamingStrategy.PropertyNamingStrategyBase propertyNamingStrategyBase = nsb = ns instanceof PropertyNamingStrategy.PropertyNamingStrategyBase ? (PropertyNamingStrategy.PropertyNamingStrategyBase)ns : null;
            if (propertyName != null && beanOrClass instanceof DataSupport) {
                DataSupport ds = (DataSupport)beanOrClass;
                for (int i = propertyName.length() - 1; i >= 0; --i) {
                    char c = propertyName.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    if (!ignoreUnknown) {
                        throw new UnrecognizedPropertyException("Unknown attribute", jp.getCurrentLocation(), beanOrClass.getClass(), propertyName, null);
                    }
                    break block34;
                }
                if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                    jp.nextToken();
                    String keyType = PSDKJSONConstants.getJSONKeyForValueType((PropertyNamingStrategy)nsb);
                    String keyValue = PSDKJSONConstants.getJSONKeyForValue((PropertyNamingStrategy)nsb);
                    boolean typeDefined = false;
                    boolean valueDefined = false;
                    String type = null;
                    String valueString = null;
                    Number valueNumber = null;
                    byte[] valueBinary = null;
                    String key = null;
                    while (!typeDefined || !valueDefined) {
                        if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                            throw new JsonParseException("FIELD_NAME token is expected. But found " + jp.getCurrentToken(), jp.getCurrentLocation());
                        }
                        key = jp.getText();
                        if (!typeDefined && keyType.equals(key)) {
                            jp.nextToken();
                            type = jp.getText();
                            typeDefined = true;
                            jp.nextToken();
                            continue;
                        }
                        if (!valueDefined && keyValue.equals(key)) {
                            jp.nextToken();
                            if (JsonToken.VALUE_NUMBER_INT.equals((Object)jp.getCurrentToken())) {
                                valueNumber = jp.getNumberValue();
                                valueString = null;
                                valueBinary = null;
                            } else {
                                valueNumber = null;
                                valueString = jp.getText();
                                try {
                                    valueBinary = jp.getBinaryValue();
                                }
                                catch (Throwable ex) {
                                    valueBinary = null;
                                }
                            }
                            valueDefined = true;
                            jp.nextToken();
                            continue;
                        }
                        if (ignoreUnknown) {
                            jp.nextToken();
                            if (JsonToken.START_ARRAY.equals((Object)jp.getCurrentToken()) || JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                                jp.skipChildren();
                                continue;
                            }
                            jp.nextToken();
                            continue;
                        }
                        throw new UnrecognizedPropertyException("Only 'type' and 'value' attributes are allowed here", jp.getCurrentLocation(), null, key, null);
                    }
                    if (ignoreUnknown) {
                        while (!JsonToken.END_OBJECT.equals((Object)jp.getCurrentToken())) {
                            if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                                throw new JsonParseException("FIELD_NAME or END_OBJECT tokens are expected. But found " + jp.getCurrentToken(), jp.getCurrentLocation());
                            }
                            jp.nextToken();
                            if (JsonToken.START_ARRAY.equals((Object)jp.getCurrentToken()) || JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                                jp.skipChildren();
                                continue;
                            }
                            jp.nextToken();
                        }
                    } else if (!JsonToken.END_OBJECT.equals((Object)jp.getCurrentToken())) {
                        if (JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                            throw new UnrecognizedPropertyException("Only 'type' and 'value' attributes are allowed here", jp.getCurrentLocation(), null, jp.getText(), null);
                        }
                        throw new JsonParseException("Raw attribute end token is expected. But found " + jp.getCurrentToken(), jp.getCurrentLocation());
                    }
                    if ("i".equals(type)) {
                        if (valueNumber != null) {
                            ds.attributes().put(propertyName, valueNumber.intValue());
                            return true;
                        }
                    } else if ("l".equals(type)) {
                        if (valueNumber != null) {
                            ds.attributes().put(propertyName, valueNumber.longValue());
                            return true;
                        }
                    } else if ("s".equals(type)) {
                        if (valueString != null) {
                            ds.attributes().put(propertyName, valueString);
                            return true;
                        }
                    } else if ("b".equals(type)) {
                        if (valueBinary != null) {
                            ds.attributes().put(propertyName, valueBinary);
                            return true;
                        }
                    } else if (type != null && (type = type.trim()).length() == 2 && type.startsWith("r")) {
                        char raw_type = type.charAt(1);
                        ds.attributes().put(propertyName, new AttributeRawValue(raw_type, valueBinary));
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

