/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.callback;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.callback.EventAckDeserializer;
import com.genesyslab.platform.json.jackson2.callback.EventErrorDeserializer;
import com.genesyslab.platform.json.jackson2.callback.EventErrorMixIn;
import com.genesyslab.platform.json.jackson2.callback.EventInfoDeserializer;
import com.genesyslab.platform.json.jackson2.callback.EventRedirectDeserializer;
import com.genesyslab.platform.json.jackson2.callback.EventRedirectMixIn;
import com.genesyslab.platform.json.jackson2.callback.EventSearchResultDeserializer;
import com.genesyslab.platform.json.jackson2.callback.EventStatInfoDeserializer;
import com.genesyslab.platform.json.jackson2.callback.EventStatInfoMixIn;
import com.genesyslab.platform.json.jackson2.callback.MediaTypeDeserializer;
import com.genesyslab.platform.json.jackson2.callback.ProcessingStatusDeserializer;
import com.genesyslab.platform.json.jackson2.callback.RequestCallbackDeserializer;
import com.genesyslab.platform.json.jackson2.callback.RequestCancelDeserializer;
import com.genesyslab.platform.json.jackson2.callback.RequestGetInfoDeserializer;
import com.genesyslab.platform.json.jackson2.callback.RequestGetStatisticsDeserializer;
import com.genesyslab.platform.json.jackson2.callback.RequestSearchDeserializer;
import com.genesyslab.platform.json.jackson2.callback.SearchResultDeserializer;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import com.genesyslab.platform.webmedia.protocol.callback.CallbackMessage;
import com.genesyslab.platform.webmedia.protocol.callback.CallbackProtocolFactory;
import com.genesyslab.platform.webmedia.protocol.callback.MediaType;
import com.genesyslab.platform.webmedia.protocol.callback.ProcessingStatus;
import com.genesyslab.platform.webmedia.protocol.callback.SearchResult;
import com.genesyslab.platform.webmedia.protocol.callback.events.EventAck;
import com.genesyslab.platform.webmedia.protocol.callback.events.EventError;
import com.genesyslab.platform.webmedia.protocol.callback.events.EventInfo;
import com.genesyslab.platform.webmedia.protocol.callback.events.EventRedirect;
import com.genesyslab.platform.webmedia.protocol.callback.events.EventSearchResult;
import com.genesyslab.platform.webmedia.protocol.callback.events.EventStatInfo;
import com.genesyslab.platform.webmedia.protocol.callback.requests.RequestCallback;
import com.genesyslab.platform.webmedia.protocol.callback.requests.RequestCancel;
import com.genesyslab.platform.webmedia.protocol.callback.requests.RequestGetInfo;
import com.genesyslab.platform.webmedia.protocol.callback.requests.RequestGetStatistics;
import com.genesyslab.platform.webmedia.protocol.callback.requests.RequestSearch;
import java.io.IOException;

public class CallbackModule
extends PSDKCommonModule {
    public CallbackModule() {
        this(false);
    }

    public CallbackModule(boolean enableMessageNameSerialization) {
        super("Callback", "WebMedia", Version.unknownVersion(), enableMessageNameSerialization);
        CallbackModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        CallbackModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(ProcessingStatus.class, new ProcessingStatusDeserializer());
        module.addDeserializer(MediaType.class, new MediaTypeDeserializer());
        module.addDeserializer(RequestCallback.class, new RequestCallbackDeserializer());
        module.addDeserializer(RequestCancel.class, new RequestCancelDeserializer());
        module.addDeserializer(RequestSearch.class, new RequestSearchDeserializer());
        module.addDeserializer(RequestGetInfo.class, new RequestGetInfoDeserializer());
        module.addDeserializer(RequestGetStatistics.class, new RequestGetStatisticsDeserializer());
        module.addDeserializer(EventRedirect.class, new EventRedirectDeserializer());
        module.addDeserializer(EventInfo.class, new EventInfoDeserializer());
        module.addDeserializer(EventStatInfo.class, new EventStatInfoDeserializer());
        module.addDeserializer(EventAck.class, new EventAckDeserializer());
        module.addDeserializer(EventError.class, new EventErrorDeserializer());
        module.addDeserializer(EventSearchResult.class, new EventSearchResultDeserializer());
        module.addDeserializer(SearchResult.class, new SearchResultDeserializer());
        if (module instanceof CallbackModule) {
            module.addDeserializer(CallbackMessage.class, (JsonDeserializer)new JsonDeserializer<CallbackMessage>(){

                public CallbackMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (CallbackMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
        context.setMixInAnnotations(EventRedirect.class, EventRedirectMixIn.class);
        context.setMixInAnnotations(EventStatInfo.class, EventStatInfoMixIn.class);
        context.setMixInAnnotations(EventError.class, EventErrorMixIn.class);
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("WebMedia", "Callback");
    }

    @Override
    public Class<?> getMarkerClass() {
        return CallbackMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends CallbackProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

