/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.contactserver;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.contacts.protocol.contactserver.BaseEntityAttributes;
import com.genesyslab.platform.contacts.protocol.contactserver.BaseSearchCriteria;
import com.genesyslab.platform.contacts.protocol.contactserver.CoBrowseAction;
import com.genesyslab.platform.contacts.protocol.contactserver.ContactServerMessage;
import com.genesyslab.platform.contacts.protocol.contactserver.ContactServerProtocolFactory;
import com.genesyslab.platform.contacts.protocol.contactserver.DataSourceType;
import com.genesyslab.platform.contacts.protocol.contactserver.EntityTypes;
import com.genesyslab.platform.contacts.protocol.contactserver.ErrorCodes;
import com.genesyslab.platform.contacts.protocol.contactserver.IndexNameType;
import com.genesyslab.platform.contacts.protocol.contactserver.Operators;
import com.genesyslab.platform.contacts.protocol.contactserver.Prefixes;
import com.genesyslab.platform.contacts.protocol.contactserver.ResponseType;
import com.genesyslab.platform.contacts.protocol.contactserver.SortMode;
import com.genesyslab.platform.contacts.protocol.contactserver.Statuses;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.contactserver.BaseEntityAttributesMixIn;
import com.genesyslab.platform.json.jackson2.contactserver.BaseSearchCriteriaMixIn;
import com.genesyslab.platform.json.jackson2.contactserver.CoBrowseActionDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.DataSourceTypeDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.EntityTypesDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.ErrorCodesDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.IndexNameTypeDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.OperatorsDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.PrefixesDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.ResponseTypeDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.SortModeDeserializer;
import com.genesyslab.platform.json.jackson2.contactserver.StatusesDeserializer;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import java.io.IOException;

public class ContactServerModule
extends PSDKCommonModule {
    public ContactServerModule() {
        this(false);
    }

    public ContactServerModule(boolean enableMessageNameSerialization) {
        super("ContactServer", "Contacts", Version.unknownVersion(), enableMessageNameSerialization);
        ContactServerModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        ContactServerModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(DataSourceType.class, new DataSourceTypeDeserializer());
        module.addDeserializer(Prefixes.class, new PrefixesDeserializer());
        module.addDeserializer(Operators.class, new OperatorsDeserializer());
        module.addDeserializer(ErrorCodes.class, new ErrorCodesDeserializer());
        module.addDeserializer(SortMode.class, new SortModeDeserializer());
        module.addDeserializer(Statuses.class, new StatusesDeserializer());
        module.addDeserializer(EntityTypes.class, new EntityTypesDeserializer());
        module.addDeserializer(CoBrowseAction.class, new CoBrowseActionDeserializer());
        module.addDeserializer(ResponseType.class, new ResponseTypeDeserializer());
        module.addDeserializer(IndexNameType.class, new IndexNameTypeDeserializer());
        if (module instanceof ContactServerModule) {
            module.addDeserializer(ContactServerMessage.class, (JsonDeserializer)new JsonDeserializer<ContactServerMessage>(){

                public ContactServerMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (ContactServerMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
        context.setMixInAnnotations(BaseEntityAttributes.class, BaseEntityAttributesMixIn.class);
        context.setMixInAnnotations(BaseSearchCriteria.class, BaseSearchCriteriaMixIn.class);
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("Contacts", "ContactServer");
    }

    @Override
    public Class<?> getMarkerClass() {
        return ContactServerMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends ContactServerProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

