/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.customserver;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.customserver.ErrorCodeDeserializer;
import com.genesyslab.platform.json.jackson2.customserver.EventDeletedDeserializer;
import com.genesyslab.platform.json.jackson2.customserver.EventErrorDeserializer;
import com.genesyslab.platform.json.jackson2.customserver.EventErrorMixIn;
import com.genesyslab.platform.json.jackson2.customserver.EventInfoDeserializer;
import com.genesyslab.platform.json.jackson2.customserver.EventInfoMixIn;
import com.genesyslab.platform.json.jackson2.customserver.EventOpenOkDeserializer;
import com.genesyslab.platform.json.jackson2.customserver.EventOpenOkMixIn;
import com.genesyslab.platform.json.jackson2.customserver.RequestExecuteProcedureDeserializer;
import com.genesyslab.platform.json.jackson2.customserver.RequestRegisterClientDeserializer;
import com.genesyslab.platform.json.jackson2.customserver.RequestUnregisterClientDeserializer;
import com.genesyslab.platform.json.jackson2.customserver.StatusDeserializer;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import com.genesyslab.platform.routing.protocol.customserver.CustomServerMessage;
import com.genesyslab.platform.routing.protocol.customserver.ErrorCode;
import com.genesyslab.platform.routing.protocol.customserver.Status;
import com.genesyslab.platform.routing.protocol.customserver.events.EventDeleted;
import com.genesyslab.platform.routing.protocol.customserver.events.EventError;
import com.genesyslab.platform.routing.protocol.customserver.events.EventInfo;
import com.genesyslab.platform.routing.protocol.customserver.events.EventOpenOk;
import com.genesyslab.platform.routing.protocol.customserver.requests.RequestExecuteProcedure;
import com.genesyslab.platform.routing.protocol.customserver.requests.RequestUnregisterClient;
import com.genesyslab.platform.routing.protocol.customserver.runtime.CustomServerInternalProtocolFactory;
import com.genesyslab.platform.routing.protocol.customserver.runtime.channel.RequestRegisterClient;
import java.io.IOException;

public class CustomServerModule
extends PSDKCommonModule {
    public CustomServerModule() {
        this(false);
    }

    public CustomServerModule(boolean enableMessageNameSerialization) {
        super("CustomServer", "Routing", Version.unknownVersion(), enableMessageNameSerialization);
        CustomServerModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        CustomServerModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(ErrorCode.class, new ErrorCodeDeserializer());
        module.addDeserializer(Status.class, new StatusDeserializer());
        module.addDeserializer(RequestRegisterClient.class, new RequestRegisterClientDeserializer());
        module.addDeserializer(RequestUnregisterClient.class, new RequestUnregisterClientDeserializer());
        module.addDeserializer(RequestExecuteProcedure.class, new RequestExecuteProcedureDeserializer());
        module.addDeserializer(EventError.class, new EventErrorDeserializer());
        module.addDeserializer(EventInfo.class, new EventInfoDeserializer());
        module.addDeserializer(EventDeleted.class, new EventDeletedDeserializer());
        module.addDeserializer(EventOpenOk.class, new EventOpenOkDeserializer());
        if (module instanceof CustomServerModule) {
            module.addDeserializer(CustomServerMessage.class, (JsonDeserializer)new JsonDeserializer<CustomServerMessage>(){

                public CustomServerMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (CustomServerMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
        context.setMixInAnnotations(EventError.class, EventErrorMixIn.class);
        context.setMixInAnnotations(EventInfo.class, EventInfoMixIn.class);
        context.setMixInAnnotations(EventOpenOk.class, EventOpenOkMixIn.class);
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("Routing", "CustomServer");
    }

    @Override
    public Class<?> getMarkerClass() {
        return CustomServerMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends CustomServerInternalProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

