/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.jackson2.localcontrolagent;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventApplicationRegisteredDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventApplicationRegisteredMixIn;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventChangeExecutionModeDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventChangeExecutionModeMixIn;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventHostUnderControlDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventHostUnderControlMixIn;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventInitHeartbeatsDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventInitHeartbeatsMixIn;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventNoControllingSCSDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.EventSuspendApplicationDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.LcaEventDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.LcaEventMixIn;
import com.genesyslab.platform.json.jackson2.localcontrolagent.RequestRegisterApplicationDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.RequestRegisterApplicationMixIn;
import com.genesyslab.platform.json.jackson2.localcontrolagent.RequestSCSConnectionStatusDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.RequestUpdateStatusDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.RequestUpdateStatusMixIn;
import com.genesyslab.platform.json.jackson2.localcontrolagent.ResponseExecutionModeChangedDeserializer;
import com.genesyslab.platform.json.jackson2.localcontrolagent.ResponseExecutionModeChangedMixIn;
import com.genesyslab.platform.json.jackson2.runtime.ProtocolUnknownMessageDeserializer;
import com.genesyslab.platform.management.protocol.localcontrolagent.LocalControlAgentMessage;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventChangeExecutionMode;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventHostUnderControl;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventInitHeartbeats;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventNoControllingSCS;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.EventSuspendApplication;
import com.genesyslab.platform.management.protocol.localcontrolagent.events.LcaEvent;
import com.genesyslab.platform.management.protocol.localcontrolagent.requests.RequestSCSConnectionStatus;
import com.genesyslab.platform.management.protocol.localcontrolagent.requests.RequestUpdateStatus;
import com.genesyslab.platform.management.protocol.localcontrolagent.responses.ResponseExecutionModeChanged;
import com.genesyslab.platform.management.protocol.localcontrolagent.runtime.LocalControlAgentInternalProtocolFactory;
import com.genesyslab.platform.management.protocol.localcontrolagent.runtime.channel.EventApplicationRegistered;
import com.genesyslab.platform.management.protocol.localcontrolagent.runtime.channel.RequestRegisterApplication;
import java.io.IOException;

public class LocalControlAgentModule
extends PSDKCommonModule {
    public LocalControlAgentModule() {
        this(false);
    }

    public LocalControlAgentModule(boolean enableMessageNameSerialization) {
        super("LocalControlAgent", "Management", Version.unknownVersion(), enableMessageNameSerialization);
        LocalControlAgentModule.init(this);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        LocalControlAgentModule.setup(context);
    }

    public static void init(PSDKCommonModule module) {
        module.addDeserializer(ProtocolUnknownMessage.class, FactoryHolder.unknownMessageDeserializer);
        module.addDeserializer(RequestRegisterApplication.class, new RequestRegisterApplicationDeserializer());
        module.addDeserializer(ResponseExecutionModeChanged.class, new ResponseExecutionModeChangedDeserializer());
        module.addDeserializer(RequestUpdateStatus.class, new RequestUpdateStatusDeserializer());
        module.addDeserializer(RequestSCSConnectionStatus.class, new RequestSCSConnectionStatusDeserializer());
        module.addDeserializer(EventApplicationRegistered.class, new EventApplicationRegisteredDeserializer());
        module.addDeserializer(EventChangeExecutionMode.class, new EventChangeExecutionModeDeserializer());
        module.addDeserializer(EventSuspendApplication.class, new EventSuspendApplicationDeserializer());
        module.addDeserializer(EventInitHeartbeats.class, new EventInitHeartbeatsDeserializer());
        module.addDeserializer(EventHostUnderControl.class, new EventHostUnderControlDeserializer());
        module.addDeserializer(EventNoControllingSCS.class, new EventNoControllingSCSDeserializer());
        module.addDeserializer(LcaEvent.class, new LcaEventDeserializer());
        if (module instanceof LocalControlAgentModule) {
            module.addDeserializer(LocalControlAgentMessage.class, (JsonDeserializer)new JsonDeserializer<LocalControlAgentMessage>(){

                public LocalControlAgentMessage deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    String messageNameKey = "messageName";
                    PropertyNamingStrategy strategy = ((ObjectMapper)jp.getCodec()).getDeserializationConfig().getPropertyNamingStrategy();
                    if (strategy instanceof PropertyNamingStrategy.PropertyNamingStrategyBase) {
                        PropertyNamingStrategy.PropertyNamingStrategyBase base = (PropertyNamingStrategy.PropertyNamingStrategyBase)strategy;
                        messageNameKey = base.translate(messageNameKey);
                    }
                    String messageName = null;
                    if (JsonToken.START_OBJECT.equals((Object)jp.getCurrentToken())) {
                        jp.nextToken();
                    }
                    if (!JsonToken.FIELD_NAME.equals((Object)jp.getCurrentToken())) {
                        throw new JsonParseException("The attribute name is expected", jp.getCurrentLocation());
                    }
                    TokenBuffer tb = new TokenBuffer(null, false);
                    tb.writeStartObject();
                    String keyName = jp.getText();
                    if (messageNameKey.equals(keyName)) {
                        if (!JsonToken.VALUE_STRING.equals((Object)jp.nextToken())) {
                            throw new JsonParseException("The text attribute '" + messageNameKey + "' is expected at the begin of json", jp.getCurrentLocation());
                        }
                        messageName = jp.getText();
                    } else {
                        JsonToken t = jp.getCurrentToken();
                        while (t == JsonToken.FIELD_NAME) {
                            String name = jp.getCurrentName();
                            jp.nextToken();
                            if (messageNameKey.equals(name)) {
                                messageName = jp.getText();
                                jp.nextToken();
                                break;
                            }
                            tb.writeFieldName(name);
                            tb.copyCurrentStructure(jp);
                            t = jp.nextToken();
                        }
                    }
                    jp = JsonParserSequence.createFlattened((JsonParser)tb.asParser(jp), (JsonParser)jp);
                    jp.nextToken();
                    if (messageName != null) {
                        ProtocolUnknownMessage msg;
                        if ("ProtocolUnknownMessage".equals(messageName)) {
                            msg = FactoryHolder.unknownMessageDeserializer.deserialize(jp, ctxt);
                        } else {
                            Class c = FactoryHolder.protocolFactory.getMessageClass(messageName);
                            msg = (Message)jp.getCodec().readValue(jp, c);
                        }
                        return (LocalControlAgentMessage)msg;
                    }
                    throw new JsonParseException("The attribute '" + messageNameKey + "' is expected (it should be the first JSON attribute)", jp.getCurrentLocation());
                }
            });
        }
    }

    public static void setup(Module.SetupContext context) {
        context.setMixInAnnotations(LcaEvent.class, LcaEventMixIn.class);
        context.setMixInAnnotations(RequestRegisterApplication.class, RequestRegisterApplicationMixIn.class);
        context.setMixInAnnotations(ResponseExecutionModeChanged.class, ResponseExecutionModeChangedMixIn.class);
        context.setMixInAnnotations(RequestUpdateStatus.class, RequestUpdateStatusMixIn.class);
        context.setMixInAnnotations(EventApplicationRegistered.class, EventApplicationRegisteredMixIn.class);
        context.setMixInAnnotations(EventChangeExecutionMode.class, EventChangeExecutionModeMixIn.class);
        context.setMixInAnnotations(EventInitHeartbeats.class, EventInitHeartbeatsMixIn.class);
        context.setMixInAnnotations(EventHostUnderControl.class, EventHostUnderControlMixIn.class);
    }

    public static boolean isAvailable() {
        return PSDKCommonModule.isProtocolAvailable("Management", "LocalControlAgent");
    }

    @Override
    public Class<?> getMarkerClass() {
        return LocalControlAgentMessage.class;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name) {
        return FactoryHolder.protocolFactory.getMessageClass(name);
    }

    @Override
    public ProtocolUnknownMessage createUnknownMessage(int messageId) {
        return FactoryHolder.protocolFactory.unknownProtocolMessage(messageId);
    }

    private static class FactoryHolder
    extends LocalControlAgentInternalProtocolFactory {
        private static final FactoryHolder protocolFactory = new FactoryHolder();
        private static final ProtocolUnknownMessageDeserializer unknownMessageDeserializer = new ProtocolUnknownMessageDeserializer((AbstractProtocolFactory)protocolFactory);

        private FactoryHolder() {
        }

        public ProtocolUnknownMessage unknownProtocolMessage(int messageId) {
            return (ProtocolUnknownMessage)super.unknownProtocolMessage(messageId);
        }
    }
}

