/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.json.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.json.jackson2.PSDKCommonModule;
import com.genesyslab.platform.json.jackson2.basicchat.BasicChatModule;
import com.genesyslab.platform.json.jackson2.callback.CallbackModule;
import com.genesyslab.platform.json.jackson2.confserver.ConfServerModule;
import com.genesyslab.platform.json.jackson2.contactserver.ContactServerModule;
import com.genesyslab.platform.json.jackson2.customserver.CustomServerModule;
import com.genesyslab.platform.json.jackson2.email.EmailModule;
import com.genesyslab.platform.json.jackson2.espemail.EspEmailModule;
import com.genesyslab.platform.json.jackson2.externalservice.ExternalServiceModule;
import com.genesyslab.platform.json.jackson2.flexchat.FlexChatModule;
import com.genesyslab.platform.json.jackson2.interactionserver.InteractionServerModule;
import com.genesyslab.platform.json.jackson2.localcontrolagent.LocalControlAgentModule;
import com.genesyslab.platform.json.jackson2.messageserver.MessageServerModule;
import com.genesyslab.platform.json.jackson2.outboundserver.OutboundServerModule;
import com.genesyslab.platform.json.jackson2.routingserver.RoutingServerModule;
import com.genesyslab.platform.json.jackson2.solutioncontrolserver.SolutionControlServerModule;
import com.genesyslab.platform.json.jackson2.statserver.StatServerModule;
import com.genesyslab.platform.json.jackson2.tserver.TServerModule;
import com.genesyslab.platform.json.serializer.PsdkSerializationException;

public class PsdkJsonSerializer {
    private final ObjectMapper mapper = new ObjectMapper();
    private final PSDKCommonModule module;

    private PsdkJsonSerializer(PSDKCommonModule module) {
        this.module = module;
        this.mapper.registerModule((Module)module);
    }

    public String serialize(Object value) throws PsdkSerializationException {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new PsdkSerializationException("JSON serialization failed", e);
        }
    }

    public Message deserialize(String json) throws PsdkSerializationException {
        try {
            return (Message)this.mapper.readValue(json, this.module.getMarkerClass());
        }
        catch (Exception e) {
            throw new PsdkSerializationException("JSON deserialization failed: " + json, e);
        }
    }

    public Message deserialize(String json, String messageName) throws PsdkSerializationException {
        try {
            Class<? extends Message> messageClass = this.module.getMessageClass(messageName);
            if (messageClass == null) {
                throw new IllegalArgumentException("'" + messageName + "' is unknown message name");
            }
            return (Message)this.mapper.readValue(json, messageClass);
        }
        catch (Exception e) {
            throw new PsdkSerializationException("JSON deserialization failed: " + json, e);
        }
    }

    public <T> T deserialize(String json, Class<T> classType) throws PsdkSerializationException {
        try {
            return (T)this.mapper.readValue(json, classType);
        }
        catch (Exception e) {
            throw new PsdkSerializationException("JSON deserialization failed: " + json, e);
        }
    }

    public static PsdkJsonSerializer createBasicChatSerializer() {
        return new PsdkJsonSerializer(new BasicChatModule(true));
    }

    public static PsdkJsonSerializer createCallbackSerializer() {
        return new PsdkJsonSerializer(new CallbackModule(true));
    }

    public static PsdkJsonSerializer createConfServerSerializer() {
        return new PsdkJsonSerializer(new ConfServerModule(true));
    }

    public static PsdkJsonSerializer createContactServerSerializer() {
        return new PsdkJsonSerializer(new ContactServerModule(true));
    }

    public static PsdkJsonSerializer createCustomServerSerializer() {
        return new PsdkJsonSerializer(new CustomServerModule(true));
    }

    public static PsdkJsonSerializer createEmailSerializer() {
        return new PsdkJsonSerializer(new EmailModule(true));
    }

    public static PsdkJsonSerializer createEspEmailSerializer() {
        return new PsdkJsonSerializer(new EspEmailModule(true));
    }

    public static PsdkJsonSerializer createExternalServiceSerializer() {
        return new PsdkJsonSerializer(new ExternalServiceModule(true));
    }

    public static PsdkJsonSerializer createFlexChatSerializer() {
        return new PsdkJsonSerializer(new FlexChatModule(true));
    }

    public static PsdkJsonSerializer createInteractionServerSerializer() {
        return new PsdkJsonSerializer(new InteractionServerModule(true));
    }

    public static PsdkJsonSerializer createLocalControlAgentSerializer() {
        return new PsdkJsonSerializer(new LocalControlAgentModule(true));
    }

    public static PsdkJsonSerializer createMessageServerSerializer() {
        return new PsdkJsonSerializer(new MessageServerModule(true));
    }

    public static PsdkJsonSerializer createOutboundServerSerializer() {
        return new PsdkJsonSerializer(new OutboundServerModule(true));
    }

    public static PsdkJsonSerializer createSolutionControlServerSerializer() {
        return new PsdkJsonSerializer(new SolutionControlServerModule(true));
    }

    public static PsdkJsonSerializer createStatServerSerializer() {
        return new PsdkJsonSerializer(new StatServerModule(true));
    }

    public static PsdkJsonSerializer createTServerSerializer() {
        return new PsdkJsonSerializer(new TServerModule(true));
    }

    public static PsdkJsonSerializer createRoutingServerSerializer() {
        return new PsdkJsonSerializer(new RoutingServerModule(true));
    }
}

