/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.PropertyConfiguration;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.DuplexChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Referenceable;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableDescription;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableProtocolId;
import com.genesyslab.platform.contacts.protocol.UniversalContactServerProtocolHandshakeOptions;
import com.genesyslab.platform.contacts.protocol.contactserver.AbstractMessage;
import com.genesyslab.platform.contacts.protocol.contactserver.ContactServerProtocolFactory;
import com.genesyslab.platform.contacts.protocol.contactserver.runtime.ContactServerBinding;
import com.genesyslab.platform.contacts.protocol.contactserver.runtime.ContactServerFactory;
import com.genesyslab.platform.openmedia.protocol.ExternalServiceProtocol;
import com.genesyslab.platform.openmedia.protocol.externalservice.event.Event3rdServerFault;
import com.genesyslab.platform.openmedia.protocol.externalservice.event.Event3rdServerResponse;
import com.genesyslab.platform.openmedia.protocol.externalservice.request.Request3rdServer;
import java.util.Hashtable;

@ProtocolDescription.Tag(sdkName="Contacts", protocolName="ContactServer")
public class UniversalContactServerProtocol
extends ExternalServiceProtocol
implements UniversalContactServerProtocolHandshakeOptions {
    private static final boolean DEBUG_KVBINDING = System.getProperty("com.genesyslab.platform.contacts.protocol.kvbinding.debug", "").equals("1");
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = ContactServerProtocolFactory.PROTOCOL_DESCRIPTION;
    private static final Hashtable<String, String> SERVICES = new Hashtable();
    private static final String OM_CONTACTS = "OMContacts";
    private static final String OM_INTERACTIONS = "OMInteractions";
    private static final String OM_RESPONSE = "OMResponse";
    private static final String OM_FIELD_CODES = "OMFieldCodes";
    private static final String SYSTEM_INFORMATION = "SystemInformation";
    private static final String INDEX = "Index";
    private static final String RESOURCE_PROPERTY = "ResourceProperty";
    public static final String USE_UTF_FOR_RESPONSES = "UseUtfForResponses";
    @Deprecated
    public static final String MULTIBYTES_DEFAULT_KEY = "UseUtfForResponses";
    public static final String USE_UTF_FOR_REQUESTS = "UTF_STRING";
    @Deprecated
    public static final String UTF_STRING_KEY = "UTF_STRING";
    private static final ILogger log = Log.getLogger(UniversalContactServerProtocol.class);
    private static final String VERSION = "1.0";
    private String clientName = null;
    private String clientType = null;
    private boolean useUtfForResponses = true;

    public static void registerServiceMethod(String service, String method) {
        SERVICES.put(method, service);
    }

    public UniversalContactServerProtocol() {
        this(null);
    }

    public UniversalContactServerProtocol(Endpoint endpoint) {
        this(endpoint, null);
    }

    public UniversalContactServerProtocol(Endpoint endpoint, ReferenceBuilder refBuilder) {
        super(endpoint, refBuilder);
        this.connectionContext().setAttribute("protocol-server-type", (Object)"ContactServer");
    }

    public ProtocolDescription getProtocolDescription() {
        return PROTOCOL_DESCRIPTION;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public String getClientApplicationType() {
        return this.clientType;
    }

    @Override
    public void setClientApplicationType(String clientAppType) {
        this.clientType = clientAppType;
    }

    protected void applyConfiguration() {
        String strUtf4Requests;
        ConnectionConfiguration config = this.getConfiguration();
        if (config == null) {
            config = new PropertyConfiguration();
            this.setConfiguration(config);
        }
        if ((strUtf4Requests = config.getOption("UTF_STRING")) == null) {
            config.setBoolean("UTF_STRING", true);
        }
        super.applyConfiguration();
        this.useUtfForResponses = config.getBoolean("UseUtfForResponses", true);
    }

    protected void doSend(Message message) throws ProtocolException {
        Message messageToSend = UniversalContactServerProtocol.processSentMessage((DuplexChannel)this, message, this.useUtfForResponses, this.getReferenceBuilder());
        super.doSend(messageToSend);
    }

    protected static Message processSentMessage(DuplexChannel channel, Message message, boolean useUtf, ReferenceBuilder referenceBuilder) throws ProtocolException {
        if (message instanceof AbstractMessage) {
            AbstractMessage msg = (AbstractMessage)message;
            Message esp = UniversalContactServerProtocol.toEsp(channel, message, useUtf);
            if (esp == null) {
                throw new ProtocolException("Can not send message '{" + message.messageName() + "}' Id ={" + message.messageId() + "}");
            }
            Object refId = msg.retreiveReference();
            if (refId == null) {
                refId = referenceBuilder.createReference();
                msg.updateReference(refId);
            }
            ((Referenceable)esp).updateReference(refId);
            if (esp instanceof UpdatableDescription) {
                ((UpdatableDescription)esp).setProtocolDescription(channel.getProtocolDescription());
            }
            msg.setEndpoint(channel.getEndpoint());
            msg.setProtocolId(channel.getProtocolId());
            return esp;
        }
        if (ExternalServiceProtocol.PROTOCOL_DESCRIPTION.equals((Object)message.getProtocolDescription()) && message instanceof UpdatableDescription) {
            ((UpdatableDescription)message).setProtocolDescription(channel.getProtocolDescription());
        }
        return message;
    }

    private Message toEsp(Message message) throws ProtocolException {
        return UniversalContactServerProtocol.toEsp((DuplexChannel)this, message, this.useUtfForResponses);
    }

    protected static Message toEsp(DuplexChannel channel, Message message, boolean useUtfFor) throws ProtocolException {
        KeyValueCollection kvExt;
        KeyValueCollection ext = new KeyValueCollection();
        ext.addString("Version", VERSION);
        if (channel instanceof UniversalContactServerProtocolHandshakeOptions) {
            UniversalContactServerProtocolHandshakeOptions options = (UniversalContactServerProtocolHandshakeOptions)channel;
            String clientName = options.getClientName();
            String clientType = options.getClientApplicationType();
            if (clientName != null && clientName.length() > 0) {
                ext.addString("AppName", clientName);
            }
            if (clientType != null) {
                ext.addString("AppType", clientType);
            }
        } else {
            ext.addString("AppName", "");
            ext.addString("AppType", "");
        }
        String method = message.messageName();
        int methodId = UniversalContactServerProtocol.addMethodAndService(ext, method);
        UniversalContactServerProtocol.toEspRequestorInfo((Message)message, (DuplexChannel)channel, (KeyValueCollection)ext);
        try {
            kvExt = ContactServerBinding.marshal(message);
        }
        catch (ContactServerBinding.KVBindingException e) {
            log.error((Object)("[marshal error] " + message), (Throwable)((Object)e));
            throw new NullPointerException("the result of custom marshaling is null");
        }
        if (DEBUG_KVBINDING && log.isDebug()) {
            log.debugFormat("marshaled: {0}", (Object)kvExt);
        }
        if (kvExt == null) {
            return null;
        }
        if (useUtfFor) {
            kvExt.addString("tkv.multibytes", "false");
        }
        ext.addList("Parameters", kvExt);
        switch (methodId) {
            case 500: {
                Request3rdServer req = Request3rdServer.create();
                req.setRequest(ext);
                return req;
            }
            case 501: {
                Event3rdServerResponse evt = Event3rdServerResponse.create();
                evt.setRequest(ext);
                return evt;
            }
            case 502: {
                Event3rdServerFault evt = Event3rdServerFault.create();
                evt.setRequest(ext);
                return evt;
            }
        }
        return null;
    }

    protected void onReceiveMessage(Message incom) {
        Message msg = UniversalContactServerProtocol.processReceivedMessage((DuplexChannel)this, incom, log);
        super.onReceiveMessage(msg);
    }

    private Message fromEsp(Message esp) throws ProtocolException {
        return UniversalContactServerProtocol.fromEsp((DuplexChannel)this, esp);
    }

    protected static Message processReceivedMessage(DuplexChannel channel, Message incom, ILogger logger) {
        try {
            Message msg = incom;
            if (msg != null && msg.messageId() != 0) {
                Object refId = msg instanceof Referenceable ? ((Referenceable)msg).retreiveReference() : null;
                if ((msg = UniversalContactServerProtocol.fromEsp(channel, msg)) == null) {
                    msg = incom;
                } else if (refId != null && msg instanceof Referenceable) {
                    ((Referenceable)msg).updateReference(refId);
                }
            }
            return msg;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception on esp message unmarshal", (Throwable)ex);
            return null;
        }
    }

    protected static Message fromEsp(DuplexChannel channel, Message esp) {
        String messageName = "";
        String methodName = "";
        String serviceName = "";
        KeyValueCollection prms = null;
        if (esp instanceof Event3rdServerResponse) {
            prms = ((Event3rdServerResponse)esp).getRequest();
            if (prms == null) {
                return esp;
            }
            methodName = prms.getString("Method");
            serviceName = prms.getString("Service");
            messageName = "Event" + methodName;
        } else if (esp instanceof Event3rdServerFault) {
            prms = ((Event3rdServerFault)esp).getRequest();
            if (prms == null) {
                return esp;
            }
            methodName = prms.getString("Method");
            serviceName = prms.getString("Service");
            messageName = "Event" + methodName + "Error";
            if (ContactServerFactory.create(messageName) == null) {
                messageName = "EventError";
            }
        } else if (esp instanceof Request3rdServer) {
            prms = ((Request3rdServer)esp).getRequest();
            if (prms == null) {
                return esp;
            }
            methodName = prms.getString("Method");
            serviceName = prms.getString("Service");
            messageName = "Request" + methodName;
        } else {
            return esp;
        }
        KeyValueCollection kv = null;
        if (prms != null) {
            kv = prms.getList("Parameters");
        }
        Message msg = null;
        String expectedServiceName = SERVICES.get(methodName);
        if (!messageName.equals("EventError") && expectedServiceName != null && !expectedServiceName.equals(serviceName)) {
            return esp;
        }
        try {
            msg = (Message)ContactServerBinding.unmarshal(messageName, kv);
            if (DEBUG_KVBINDING && log.isDebug()) {
                log.debugFormat("unmarshaled: {0}", (Object)msg);
            }
        }
        catch (ContactServerBinding.KVBindingException e) {
            log.error((Object)("[unmarshal_error] " + messageName + " : " + kv), (Throwable)((Object)e));
            return null;
        }
        if (msg instanceof EndpointSupport) {
            ((EndpointSupport)msg).setEndpoint(channel.getEndpoint());
        }
        if (msg instanceof UpdatableProtocolId) {
            ((UpdatableProtocolId)msg).setProtocolId(channel.getProtocolId());
        }
        UniversalContactServerProtocol.fromEspRequestorInfo((KeyValueCollection)prms, (Message)msg);
        return msg;
    }

    private static int addMethodAndService(KeyValueCollection ext, String method) {
        String sRequestPref = "Request";
        int result = -1;
        int k = 0;
        if (method.startsWith("Request")) {
            k = "Request".length();
            result = 500;
        } else {
            String sEventPref = "Event";
            if (method.startsWith("Event")) {
                k = "Event".length();
                result = 501;
            }
        }
        String sMethod = method.substring(k);
        ext.addString("Service", UniversalContactServerProtocol.lookupService(sMethod));
        int i = sMethod.indexOf("Error");
        if (i != -1) {
            sMethod = sMethod.substring(0, i);
            result = 502;
        }
        ext.addString("Method", sMethod);
        return result;
    }

    private static String lookupService(String method) {
        String service = SERVICES.get(method);
        if (service == null) {
            throw new NullPointerException("no service for method '" + method);
        }
        return service;
    }

    static {
        SERVICES.put("ContactListGet", OM_CONTACTS);
        SERVICES.put("ContactListGetNextPage", OM_CONTACTS);
        SERVICES.put("ContactListRelease", OM_CONTACTS);
        SERVICES.put("GetContacts", OM_CONTACTS);
        SERVICES.put("Insert", OM_CONTACTS);
        SERVICES.put("Delete", OM_CONTACTS);
        SERVICES.put("RemoveAllAttributes", OM_CONTACTS);
        SERVICES.put("MergeContacts", OM_CONTACTS);
        SERVICES.put("GetAttributes", OM_CONTACTS);
        SERVICES.put("UpdateAttributes", OM_CONTACTS);
        SERVICES.put("Error", OM_CONTACTS);
        SERVICES.put("UnMergeContacts", OM_CONTACTS);
        SERVICES.put("MergeListGet", OM_CONTACTS);
        SERVICES.put("MergeListGetNextPage", OM_CONTACTS);
        SERVICES.put("MergeListRelease", OM_CONTACTS);
        SERVICES.put("GetMergeDetail", OM_CONTACTS);
        SERVICES.put("GetInteractionsForContact", OM_INTERACTIONS);
        SERVICES.put("InsertInteraction", OM_INTERACTIONS);
        SERVICES.put("UpdateInteraction", OM_INTERACTIONS);
        SERVICES.put("DeleteInteraction", OM_INTERACTIONS);
        SERVICES.put("SetInteractionStatus", OM_INTERACTIONS);
        SERVICES.put("GetInteractionContent", OM_INTERACTIONS);
        SERVICES.put("GetInteractionsWithStatus", OM_INTERACTIONS);
        SERVICES.put("CheckForUpdates", OM_RESPONSE);
        SERVICES.put("GetAllCategories", OM_RESPONSE);
        SERVICES.put("GetDocument", OM_INTERACTIONS);
        SERVICES.put("AddDocument", OM_INTERACTIONS);
        SERVICES.put("RemoveDocument", OM_INTERACTIONS);
        SERVICES.put("UpdateDocument", OM_INTERACTIONS);
        SERVICES.put("RenderFieldCodes", OM_FIELD_CODES);
        SERVICES.put("ValidateFieldCodes", OM_FIELD_CODES);
        SERVICES.put("FindOrCreatePhoneCall", OM_INTERACTIONS);
        SERVICES.put("AssignInteractionToContact", OM_INTERACTIONS);
        SERVICES.put("StopInteraction", OM_INTERACTIONS);
        SERVICES.put("IdentifyContact", OM_CONTACTS);
        SERVICES.put("GetAgentStdRespFavorites", OM_RESPONSE);
        SERVICES.put("AddAgentStdRespFavorite", OM_RESPONSE);
        SERVICES.put("DeleteAgentStdRespFavorite", OM_RESPONSE);
        SERVICES.put("GetVersion", SYSTEM_INFORMATION);
        SERVICES.put("InteractionListGet", OM_INTERACTIONS);
        SERVICES.put("InteractionListGetNextPage", OM_INTERACTIONS);
        SERVICES.put("InteractionListRelease", OM_INTERACTIONS);
        SERVICES.put("CountInteractions", OM_INTERACTIONS);
        SERVICES.put("Search", INDEX);
        SERVICES.put("GetIndexProperties", INDEX);
        SERVICES.put("BoostDocument", INDEX);
        SERVICES.put("GetRootCategories", OM_RESPONSE);
        SERVICES.put("GetCategory", OM_RESPONSE);
        SERVICES.put("GetStandardResponse", OM_RESPONSE);
        SERVICES.put("AddStdRespUsage", OM_RESPONSE);
        SERVICES.put("GetSystemSettings", SYSTEM_INFORMATION);
        SERVICES.put("SetProperties", RESOURCE_PROPERTY);
        SERVICES.put("GetProperties", RESOURCE_PROPERTY);
        SERVICES.put("DeleteProperties", RESOURCE_PROPERTY);
        SERVICES.put("AddStandardResponse", OM_RESPONSE);
        SERVICES.put("UpdateStandardResponse", OM_RESPONSE);
        SERVICES.put("DeleteStandardResponse", OM_RESPONSE);
        SERVICES.put("GetServerTime", SYSTEM_INFORMATION);
        SERVICES.put("Refresh", INDEX);
        SERVICES.put("GetStandardResponses", OM_RESPONSE);
        SERVICES.put("CreateStandardResponseRevision", OM_RESPONSE);
        SERVICES.put("RestoreStandardResponseRevision", OM_RESPONSE);
        SERVICES.put("AddCategoryRoot", OM_RESPONSE);
        SERVICES.put("DeleteCategoryRoot", OM_RESPONSE);
        SERVICES.put("AddCategory", OM_RESPONSE);
        SERVICES.put("MoveCategory", OM_RESPONSE);
        SERVICES.put("UpdateCategory", OM_RESPONSE);
        SERVICES.put("DeleteCategory", OM_RESPONSE);
        SERVICES.put("AddCategoryAttribute", OM_RESPONSE);
        SERVICES.put("UpdateCategoryAttribute", OM_RESPONSE);
        SERVICES.put("DeleteCategoryAttribute", OM_RESPONSE);
        SERVICES.put("GetCategoryAttribute", OM_RESPONSE);
        SERVICES.put("GetCategoryAttributes", OM_RESPONSE);
        SERVICES.put("AddFieldCode", OM_RESPONSE);
        SERVICES.put("UpdateFieldCode", OM_RESPONSE);
        SERVICES.put("DeleteFieldCode", OM_RESPONSE);
        SERVICES.put("GetFieldCode", OM_RESPONSE);
        SERVICES.put("GetFieldCodes", OM_RESPONSE);
        SERVICES.put("AddFieldValue", OM_RESPONSE);
        SERVICES.put("UpdateFieldValue", OM_RESPONSE);
        SERVICES.put("DeleteFieldValue", OM_RESPONSE);
        SERVICES.put("GetFieldValue", OM_RESPONSE);
        SERVICES.put("GetFieldValue", OM_RESPONSE);
        SERVICES.put("GetFieldValues", OM_RESPONSE);
        SERVICES.put("AddScreeningRule", OM_RESPONSE);
        SERVICES.put("UpdateScreeningRule", OM_RESPONSE);
        SERVICES.put("DeleteScreeningRule", OM_RESPONSE);
        SERVICES.put("GetScreeningRule", OM_RESPONSE);
        SERVICES.put("GetScreeningRules", OM_RESPONSE);
        ContactServerProtocolFactory.registerServices();
    }
}

