/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.contactserver;

import com.genesyslab.platform.contacts.protocol.contactserver.AbstractPrintable;
import com.genesyslab.platform.contacts.protocol.contactserver.DeleteAttributesInfo;
import com.genesyslab.platform.contacts.protocol.contactserver.DeleteAttributesList;
import com.genesyslab.platform.contacts.protocol.contactserver.Printable;
import com.genesyslab.platform.contacts.protocol.contactserver.SortCriteria;
import com.genesyslab.platform.contacts.protocol.contactserver.SortCriteriaCollection;
import com.genesyslab.platform.contacts.protocol.contactserver.StringList;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class AbstractList<T>
extends ArrayList<T>
implements Printable {
    private static final long serialVersionUID = -6693904695522294384L;

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        StringBuilder ind = AbstractPrintable.createIndent(indent);
        sb.append(this.getClass().getName()).append(" = {\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append((CharSequence)ind).append(" [").append(i).append("] = ");
            Object val = this.get(i);
            if (val instanceof Printable) {
                sb.append(((Printable)val).toString(indent + 1)).append("\n");
                continue;
            }
            sb.append(val).append(",\n");
        }
        sb.append((CharSequence)ind).append("}");
        return sb.toString();
    }

    public Iterable<T> getBindingList() {
        Class<?> clazz = this.getClass();
        if (clazz == DeleteAttributesList.class) {
            return this.getDeleteAttributesBindingList();
        }
        if (clazz == SortCriteriaCollection.class) {
            return this.getSortCriteriaCollection();
        }
        return this;
    }

    private Iterable<T> getSortCriteriaCollection() {
        if (this.size() <= 0) {
            return this;
        }
        SortCriteriaCollection sourceList = (SortCriteriaCollection)this;
        int requiredIndex = 0;
        boolean flag = true;
        for (SortCriteria criteria : sourceList) {
            Integer index = criteria.getSortIndex();
            if (index != null) {
                if (requiredIndex != index) {
                    return this;
                }
            } else {
                flag = false;
            }
            ++requiredIndex;
        }
        if (flag) {
            return this;
        }
        SortCriteriaCollection dest = new SortCriteriaCollection();
        requiredIndex = 0;
        for (SortCriteria criteria : sourceList) {
            SortCriteria criteria1 = new SortCriteria();
            criteria1.setAttrName(criteria.getAttrName());
            criteria1.setSortOperator(criteria.getSortOperator());
            criteria1.setSortIndex(requiredIndex++);
            dest.add(criteria1);
        }
        return dest;
    }

    private Iterable<T> getDeleteAttributesBindingList() {
        if (this.size() <= 0) {
            return this;
        }
        DeleteAttributesList sourceList = (DeleteAttributesList)this;
        boolean hasDuplication = false;
        LinkedHashMap<String, DeleteAttributesInfo> resultAttributes = new LinkedHashMap<String, DeleteAttributesInfo>(sourceList.size() * 2);
        for (DeleteAttributesInfo attr : sourceList) {
            if (resultAttributes.containsKey(attr.getAttrName())) {
                hasDuplication = true;
                break;
            }
            resultAttributes.put(attr.getAttrName(), attr);
        }
        if (hasDuplication) {
            resultAttributes.clear();
            for (DeleteAttributesInfo attr : sourceList) {
                DeleteAttributesInfo resultAttribute = (DeleteAttributesInfo)resultAttributes.get(attr.getAttrName());
                if (resultAttribute == null) {
                    resultAttribute = new DeleteAttributesInfo();
                    resultAttribute.setAttrName(attr.getAttrName());
                    resultAttribute.setAttrId(new StringList());
                    resultAttributes.put(attr.getAttrName(), resultAttribute);
                }
                resultAttribute.getAttrId().addAll(attr.getAttrId());
            }
            return resultAttributes.values();
        }
        return this;
    }
}

