/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.contactserver;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.UTFValue;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.contacts.protocol.contactserver.AbstractPrintable;
import com.genesyslab.platform.contacts.protocol.contactserver.Printable;
import com.genesyslab.platform.contacts.protocol.runtime.Converter;
import com.genesyslab.platform.contacts.protocol.runtime.UCSCustomCodec;
import com.genesyslab.platform.contacts.protocol.runtime.XmlSerializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DateTimeList
extends Hashtable<String, Date>
implements XmlSerializable,
Printable {
    public DateTimeList() {
    }

    public DateTimeList(KeyValueCollection col) {
        this();
        if (col != null) {
            for (KeyValuePair pair : col) {
                String val = pair.getStringValue();
                if (val.length() <= 0) continue;
                this.put(pair.getStringKey(), val);
            }
        }
    }

    @Override
    public void put(String key, Object val) {
        if (val instanceof String) {
            this.put(key, (String)val);
        } else if (val instanceof Date) {
            super.put(key, (Date)val);
        } else if (val instanceof UTFValue) {
            this.put(key, ((UTFValue)val).getValue());
        } else {
            throw new IllegalArgumentException("Can not cast " + val.toString() + " neither to string nor DateTime");
        }
    }

    @Override
    public void put(String key, String val) {
        try {
            super.put(key, Converter.toDateTime(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not parse DateTime value: " + val);
        }
    }

    public void addObject(String key, Object val) {
        this.put(key, val);
    }

    KeyValueCollection getAsKVlist() {
        KeyValueCollection col = new KeyValueCollection();
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Date dt = (Date)this.get(key);
            col.addString(key, Converter.fromDateTime(dt));
        }
        return col;
    }

    public static KeyValueCollection toKVList(DateTimeList dtl) {
        if (dtl != null) {
            return dtl.getAsKVlist();
        }
        return null;
    }

    public static DateTimeList fromKVList(Object col) {
        return new DateTimeList((KeyValueCollection)col);
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DateTimeList:\n");
        StringBuilder indentElement = AbstractPrintable.createIndent(indent + 1);
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Date dt = (Date)this.get(key);
            buffer.append((CharSequence)indentElement);
            buffer.append("[").append(key).append("] = ");
            if (dt != null) {
                buffer.append(Converter.fromDateTime(dt));
            } else {
                buffer.append("null");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int n = this.getClass().hashCode();
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Date dt = (Date)this.get(key);
            n ^= key.hashCode();
            String str = Converter.fromDateTime(dt);
            if (str == null) continue;
            n ^= str.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DateTimeList)) {
            return false;
        }
        DateTimeList dtl = (DateTimeList)obj;
        return this.hashCode() == dtl.hashCode();
    }

    @Override
    public void saveToXml(UCSCustomCodec custCodec, Node node) throws CodecException {
        Document doc = node.getOwnerDocument();
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String date = Converter.fromDateTime((Date)this.get(key));
            Element elem = doc.createElementNS(node.getNamespaceURI(), "element");
            elem.setAttribute("key", key);
            elem.setTextContent(date);
            node.appendChild(elem);
        }
    }

    @Override
    public void loadFromXml(UCSCustomCodec custCodec, Node node) throws CodecException {
        if (node != null) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!child.getNodeName().equals("element")) continue;
                Attr keyAttr = (Attr)child.getAttributes().getNamedItem("key");
                if (keyAttr == null) {
                    throw new CodecException("Error parsing datetime element: no key attribute");
                }
                String key = keyAttr.getValue();
                String val = child.getTextContent();
                try {
                    this.put(key, Converter.toDateTime(val));
                    continue;
                }
                catch (Exception e) {
                    throw new CodecException("Error parsing datetime value: " + val, (Throwable)e);
                }
            }
        }
    }
}

