/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.contactserver;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.UTFValue;
import com.genesyslab.platform.commons.collections.util.Base64;
import com.genesyslab.platform.commons.protocol.runtime.MessageTypeResolver;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.contacts.protocol.contactserver.StringInteger;
import com.genesyslab.platform.contacts.protocol.runtime.UCSCustomCodec;
import java.util.Arrays;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyValueObject
extends StringInteger {
    private KeyValueCollection kvValue = null;
    private byte[] binary = null;

    public KeyValueObject() {
    }

    public KeyValueObject(String obj) {
        super(obj);
    }

    public KeyValueObject(int obj) {
        super(obj);
    }

    public KeyValueObject(KeyValueCollection col) {
        this.kvValue = col;
    }

    public KeyValueObject(byte[] bytes) {
        this.binary = bytes;
    }

    public static Object toKVList(KeyValueObject kvo) {
        if (kvo.kvValue != null) {
            return kvo.kvValue;
        }
        if (kvo.binary != null) {
            return kvo.binary;
        }
        return StringInteger.toKVList(kvo);
    }

    public static KeyValueObject fromKVList(Object obj) {
        if (obj instanceof String) {
            return new KeyValueObject((String)obj);
        }
        if (obj instanceof UTFValue) {
            return new KeyValueObject(((UTFValue)obj).getValue());
        }
        if (obj instanceof Integer) {
            return new KeyValueObject((int)((Integer)obj));
        }
        if (obj instanceof KeyValueCollection) {
            return new KeyValueObject((KeyValueCollection)obj);
        }
        if (obj instanceof byte[]) {
            return new KeyValueObject((byte[])obj);
        }
        if (obj != null) {
            throw new IllegalArgumentException("Incorrect value type - " + obj.getClass().getName());
        }
        return null;
    }

    @Override
    public String toString(int ident) {
        if (this.kvValue != null) {
            return this.kvValue.toString();
        }
        if (this.binary != null) {
            return new String(Base64.encodeBase64((byte[])this.binary));
        }
        return super.toString(ident);
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public KeyValueCollection getKeyValueCollection() {
        return this.kvValue;
    }

    @Override
    public void setIntegerValue(Integer value) {
        super.setIntegerValue(value);
        this.kvValue = null;
        this.binary = null;
    }

    @Override
    public void setStringValue(String value) {
        super.setStringValue(value);
        this.kvValue = null;
        this.binary = null;
    }

    public void setKeyValueCollection(KeyValueCollection value) {
        this.setIntegerValue(null);
        this.kvValue = value;
    }

    public byte[] getBinaryValue() {
        return this.binary;
    }

    public void setBinaryValue(byte[] value) {
        this.setIntegerValue(null);
        this.binary = value;
    }

    @Override
    public void saveToXml(UCSCustomCodec custCodec, Node node) throws CodecException {
        Document doc = node.getOwnerDocument();
        if (this.kvValue != null) {
            Attr attr = doc.createAttribute("type");
            attr.setValue("kvlist");
            node.getAttributes().setNamedItem(attr);
            custCodec.objectToXml(this.kvValue, (Element)node);
        } else if (this.binary != null) {
            Attr attr = doc.createAttribute("type");
            attr.setValue("binary");
            node.getAttributes().setNamedItem(attr);
            custCodec.objectToXml(this.binary, (Element)node);
        } else {
            super.saveToXml(custCodec, node);
        }
    }

    @Override
    public void loadFromXml(UCSCustomCodec custCodec, Node node) throws CodecException {
        this.kvValue = null;
        this.binary = null;
        Attr type = (Attr)node.getAttributes().getNamedItem("type");
        if (type == null) {
            throw new CodecException("KeyValueObject property does not contain type attribute.");
        }
        String sType = type.getValue();
        if (MessageTypeResolver.isKVList((String)sType)) {
            this.kvValue = (KeyValueCollection)custCodec.xmlToObject(node, KeyValueCollection.class);
        } else if (MessageTypeResolver.isBinary((String)sType)) {
            this.binary = (byte[])custCodec.xmlToObject(node, byte[].class);
        } else {
            super.loadFromXml(custCodec, node);
        }
    }

    @Override
    public int hashCode() {
        if (this.kvValue != null) {
            int n = this.getClass().hashCode();
            return n ^= this.kvValue.hashCode();
        }
        if (this.binary != null) {
            int n = this.getClass().hashCode();
            for (byte b : this.binary) {
                n ^= b;
            }
            return n;
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof KeyValueObject) {
            KeyValueObject kvo = (KeyValueObject)obj;
            if (this.kvValue != null ? kvo.kvValue == null || !this.kvValue.equals((Object)kvo.kvValue) : kvo.kvValue != null) {
                return false;
            }
            if (!Arrays.equals(this.binary, kvo.binary)) {
                return false;
            }
            return super.equals(obj);
        }
        if (obj instanceof KeyValueCollection) {
            return obj.equals(this.kvValue);
        }
        if (obj instanceof byte[]) {
            return Arrays.equals(this.binary, (byte[])obj);
        }
        return super.equals(obj);
    }
}

