/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshalManager;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshaling;
import com.genesyslab.platform.contacts.protocol.runtime.UcsCustomMarshalManager;
import java.util.Collection;

public class CategoryListCustomMarshaler
implements CustomMarshaling {
    private CustomMarshalManager engine;

    public CategoryListCustomMarshaler(UcsCustomMarshalManager ucsCustomMarshalManager) {
        this.engine = ucsCustomMarshalManager;
    }

    @Override
    public int marshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) throws ProtocolException {
        KeyValueCollection sc = (KeyValueCollection)val;
        if ("SRLContent".equals(key) || "ChildrenCategories".equals(key) || "ChildrenStdResponses".equals(key) || "Categories".equals(key)) {
            KeyValueCollection content;
            String nameId = "CategoryId";
            if ("ChildrenStdResponses".equals(key)) {
                nameId = "Id";
            }
            if ((content = outKv.getList(key)) == null) {
                content = new KeyValueCollection();
                outKv.addList(key, content);
            }
            String id = sc.getString(nameId);
            sc.remove(nameId);
            content.addList(id, this.engine.marshal(sc));
            return 0;
        }
        return 2;
    }

    @Override
    public int unmarshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) throws ProtocolException {
        if ("SRLContent".equals(key) || "ChildrenCategories".equals(key) || "ChildrenStdResponses".equals(key) || "Categories".equals(key)) {
            String nameId = "CategoryId";
            if ("ChildrenStdResponses".equals(key)) {
                nameId = "Id";
            }
            KeyValueCollection sc = (KeyValueCollection)val;
            for (Object aSc : sc) {
                KeyValuePair pair = (KeyValuePair)aSc;
                String catId = pair.getStringKey();
                KeyValueCollection kvCat = (KeyValueCollection)pair.getValue();
                KeyValueCollection newKvCat = new KeyValueCollection();
                newKvCat.addAll((Collection)this.engine.unmarshal(kvCat));
                newKvCat.addString(nameId, catId);
                outKv.addList(key, newKvCat);
            }
            return 0;
        }
        return 2;
    }
}

