/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshaling;
import java.util.Enumeration;

public class ContactDataListCustomMarshaler
implements CustomMarshaling {
    @Override
    public int marshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        if ("ContactData".equals(key)) {
            Enumeration attributes;
            KeyValueCollection kv = (KeyValueCollection)val;
            KeyValueCollection sc = outKv.getList("ContactData");
            if (sc == null) {
                sc = new KeyValueCollection();
                outKv.addList("ContactData", sc);
            }
            KeyValueCollection item = new KeyValueCollection();
            if (kv.getPair("Id") != null) {
                item.addObject("Id", kv.getPair("Id").getValue());
            }
            if ((attributes = kv.getEnumeration("ContactAttributesList")).hasMoreElements()) {
                KeyValueCollection newatrs = new KeyValueCollection();
                do {
                    KeyValueCollection list = ((KeyValuePair)attributes.nextElement()).getTKVValue();
                    newatrs.addObject(list.getString("AttributeName"), list.getPair("AttributeValue").getValue());
                } while (attributes.hasMoreElements());
                item.addList("Attributes", newatrs);
            }
            sc.addList(kv.getInt("Index").toString(), item);
            return 0;
        }
        return 2;
    }

    @Override
    public int unmarshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        if ("ContactData".equals(key)) {
            KeyValueCollection kv = (KeyValueCollection)val;
            for (Pair pair : kv) {
                KeyValueCollection oldAtrs;
                if (pair == null) continue;
                String k = pair.getStringKey();
                KeyValueCollection data = (KeyValueCollection)pair.getValue();
                KeyValueCollection newKv = new KeyValueCollection();
                newKv.addInt("Index", Integer.valueOf(k));
                if (data.getPair("Id") != null) {
                    newKv.addObject("Id", data.getPair("Id").getValue());
                }
                if ((oldAtrs = data.getList("Attributes")) != null) {
                    for (Pair pair1 : oldAtrs) {
                        Object atrVal;
                        if (pair1 == null || (atrVal = pair1.getValue()) == null) continue;
                        KeyValueCollection newAtrs = new KeyValueCollection();
                        newAtrs.addString("AttributeName", pair1.getStringKey());
                        newAtrs.addObject("AttributeValue", atrVal);
                        newKv.addList("ContactAttributesList", newAtrs);
                    }
                }
                outKv.addList("ContactData", newKv);
            }
            return 0;
        }
        return 2;
    }
}

