/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshaling;
import java.util.Enumeration;

public class ContactInteractionListCustomMarshaler
implements CustomMarshaling {
    @Override
    public int marshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        if ("ContactInteractions".equals(key)) {
            KeyValueCollection kv = (KeyValueCollection)val;
            KeyValueCollection sc = outKv.getList("ContactInteractions");
            if (sc == null) {
                sc = new KeyValueCollection();
                outKv.addList("ContactInteractions", sc);
            }
            KeyValueCollection inter = new KeyValueCollection();
            sc.addList(kv.getInt("Index").toString(), inter);
            inter.addString("Id", kv.getString("InteractionId"));
            Enumeration attributes = kv.getEnumeration("InteractionAttributes");
            if (attributes.hasMoreElements()) {
                KeyValueCollection ia = new KeyValueCollection();
                do {
                    KeyValueCollection list = ((KeyValuePair)attributes.nextElement()).getTKVValue();
                    ia.addString(list.getString("AttributeName"), list.getString("AttributeValue"));
                } while (attributes.hasMoreElements());
                inter.addList("Attributes", ia);
            }
            return 0;
        }
        return 2;
    }

    @Override
    public int unmarshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        if ("ContactInteractions".equals(key)) {
            KeyValueCollection kv = (KeyValueCollection)val;
            for (KeyValuePair pair : kv) {
                int index = Integer.valueOf(pair.getStringKey());
                KeyValueCollection ikv = (KeyValueCollection)pair.getValue();
                KeyValueCollection newkv = new KeyValueCollection();
                newkv.addInt("Index", index);
                newkv.addString("InteractionId", ikv.getString("Id"));
                outKv.addList("ContactInteractions", newkv);
                KeyValueCollection ia = ikv.getList("Attributes");
                if (ia == null) continue;
                for (KeyValuePair pair1 : ia) {
                    KeyValueCollection attrs = new KeyValueCollection();
                    newkv.addList("InteractionAttributes", attrs);
                    attrs.addString("AttributeName", pair1.getStringKey());
                    attrs.addObject("AttributeValue", pair1.getValue());
                }
            }
            return 0;
        }
        return 2;
    }
}

