/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Converter {
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromDateTime(Date val) {
        if (val != null) {
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                return DATE_FORMAT.format(val);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date toDateTime(String val) {
        if (val == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                return DATE_FORMAT.parse(val);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("Exception parsing DateTime field", e);
        }
    }

    public static String fromBoolean(Boolean val) {
        if (val != null) {
            if (val.booleanValue()) {
                return "TRUE";
            }
            return "FALSE";
        }
        return null;
    }

    public static Boolean toBoolean(String val) {
        if (val == null) {
            return null;
        }
        String upc = val.toUpperCase(Locale.ENGLISH);
        if (upc.equals("TRUE") || upc.equals("YES") || upc.equals("ON") || upc.equals("1")) {
            return true;
        }
        return false;
    }

    static {
        DATE_FORMAT.setTimeZone(UTC_TIMEZONE);
    }
}

