/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.ValueType;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.runtime.KVBinding;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshaling;
import com.genesyslab.platform.contacts.protocol.runtime.MapOfArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CustomMarshalManager {
    private MapOfArrays marshalers = new MapOfArrays();
    private MapOfArrays unMarshalers = new MapOfArrays();

    public void addMarshaler(Object key, CustomMarshaling marshaler) {
        this.addToArrayMap(key, marshaler, this.marshalers);
    }

    public void addUnmarshaler(Object key, CustomMarshaling marshaler) {
        this.addToArrayMap(key, marshaler, this.unMarshalers);
    }

    public KeyValueCollection marshal(KeyValueCollection internalFormat) throws ProtocolException {
        if (KVBinding.isNewKVBindingActive()) {
            return internalFormat;
        }
        if (internalFormat == null) {
            return null;
        }
        KeyValueCollection ext = new KeyValueCollection();
        for (KeyValuePair pair : internalFormat) {
            String key = pair.getStringKey();
            Object obj = pair.getValue();
            if (pair.getValueType() == ValueType.WIDE_STRING) {
                obj = pair.getStringValue();
            }
            int rez = 2;
            ArrayList list = this.marshalers.get(key);
            if (list != null) {
                CustomMarshaling m;
                Iterator lstIter = list.iterator();
                while (lstIter.hasNext() && (rez = (m = (CustomMarshaling)lstIter.next()).marshal(ext, key, obj, internalFormat)) == 2) {
                }
            }
            if (rez == 0) continue;
            ext.addObject(key, obj);
        }
        return ext;
    }

    public KeyValueCollection unmarshal(KeyValueCollection externalFormat) throws ProtocolException {
        if (KVBinding.isNewKVBindingActive()) {
            return externalFormat;
        }
        KeyValueCollection intern = new KeyValueCollection();
        for (KeyValuePair pair : externalFormat) {
            String key = pair.getStringKey();
            Object val = pair.getValue();
            if (pair.getValueType() == ValueType.WIDE_STRING) {
                val = pair.getStringValue();
            }
            int rez = 2;
            ArrayList list = this.unMarshalers.get(key);
            if (list != null) {
                CustomMarshaling m;
                Iterator lstIter = list.iterator();
                while (lstIter.hasNext() && (rez = (m = (CustomMarshaling)lstIter.next()).unmarshal(intern, key, val, externalFormat)) == 2) {
                }
            }
            if (rez == 0) continue;
            if (val instanceof KeyValueCollection) {
                intern.addList(key, this.unmarshal((KeyValueCollection)val));
                continue;
            }
            intern.addObject(key, val);
        }
        return intern;
    }

    private void addToArrayMap(Object key, CustomMarshaling marshaler, MapOfArrays arrayMap) {
        if (key instanceof String) {
            arrayMap.add((String)key, marshaler);
        } else if (key instanceof Class) {
            Class tKey = (Class)key;
            if (this.isEnum(tKey)) {
                Collection values = GEnum.values((Class)tKey);
                for (GEnum enumValue : values) {
                    arrayMap.add(enumValue.toString(), marshaler);
                }
            }
        } else if (key instanceof String[]) {
            String[] strArr = (String[])key;
            for (int i = 0; i < strArr.length; ++i) {
                arrayMap.add(strArr[i], marshaler);
            }
        } else {
            throw new RuntimeException("type of key is not supported");
        }
    }

    public static void defaultStringKeyMarshal(KeyValueCollection outKv, String rootKey, String valuekey, KeyValueCollection kv) {
        KeyValueCollection sc = outKv.getList(rootKey);
        if (sc == null) {
            sc = new KeyValueCollection();
            outKv.addList(rootKey, sc);
        }
        String strValue = kv.getString(valuekey);
        KeyValueCollection clone = null;
        try {
            clone = (KeyValueCollection)kv.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = new KeyValueCollection();
            clone.addAll((Collection)kv);
        }
        clone.remove(valuekey);
        sc.addList(strValue, clone);
    }

    public static void defaultStringKeyUnmarshal(KeyValueCollection outKv, String rootKey, String valuekey, KeyValueCollection kv) {
        for (Object obj : kv.toArray()) {
            KeyValuePair pair = (KeyValuePair)obj;
            String k = pair.getStringKey();
            KeyValueCollection data = pair.getTKVValue();
            KeyValueCollection newKv = new KeyValueCollection();
            newKv.addAll((Collection)data);
            newKv.addString(valuekey, k);
            outKv.addList(rootKey, newKv);
        }
    }

    private boolean isEnum(Class tKey) {
        return GEnum.class.isAssignableFrom(tKey);
    }
}

