/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.util.Base64;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.MessageTypeResolver;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.NoDataCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.TKVCodec;
import com.genesyslab.platform.commons.xml.XmlUtil;
import com.genesyslab.platform.contacts.protocol.contactserver.AbstractList;
import com.genesyslab.platform.contacts.protocol.contactserver.BaseEntityAttributes;
import com.genesyslab.platform.contacts.protocol.contactserver.BaseSearchCriteria;
import com.genesyslab.platform.contacts.protocol.contactserver.NamedGEnum;
import com.genesyslab.platform.contacts.protocol.contactserver.StringList;
import com.genesyslab.platform.contacts.protocol.runtime.Converter;
import com.genesyslab.platform.contacts.protocol.runtime.XmlSerializable;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UCSCustomCodec
extends NoDataCodec
implements AttributeTypeCodec {
    private TKVCodec tkvCodec = new TKVCodec();

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        throw new PlatformException("Codec is not designed to be used for connection");
    }

    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws PlatformException {
        return value;
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        if (customTypeObject instanceof BaseEntityAttributes) {
            Node node = ((DOMResult)attributeElement).getNode();
            Document doc = node.getOwnerDocument();
            Element node1 = doc.createElementNS(node.getNamespaceURI(), customTypeObject.getClass().getSimpleName());
            node.appendChild(node1);
            ((BaseEntityAttributes)customTypeObject).saveToXml(this, node1);
        } else if (customTypeObject instanceof BaseSearchCriteria) {
            Node node = ((DOMResult)attributeElement).getNode();
            Document doc = node.getOwnerDocument();
            String scName = customTypeObject.getClass().getSimpleName();
            Element node1 = doc.createElementNS(node.getNamespaceURI(), scName);
            node.appendChild(node1);
            ((BaseSearchCriteria)customTypeObject).saveToXml(this, node1);
        } else if (customTypeObject instanceof XmlSerializable) {
            ((XmlSerializable)customTypeObject).saveToXml(this, ((DOMResult)attributeElement).getNode());
        } else if (customTypeObject instanceof List) {
            List lst = (List)customTypeObject;
            Node node = ((DOMResult)attributeElement).getNode();
            Document doc = node.getOwnerDocument();
            for (int i = 0; i < lst.size(); ++i) {
                Element elem;
                Object obj = lst.get(i);
                if (obj instanceof BaseSearchCriteria) {
                    elem = doc.createElementNS(node.getNamespaceURI(), this.className4xml(obj.getClass()));
                } else {
                    elem = doc.createElementNS(node.getNamespaceURI(), "element");
                    elem.setAttribute("type", this.className4xml(obj.getClass()));
                }
                node.appendChild(elem);
                this.objectToXml(obj, elem);
            }
        } else if (customTypeObject instanceof NamedGEnum) {
            CodecUtil.appendText((String)((NamedGEnum)((Object)customTypeObject)).getLongName(), (Result)attributeElement);
        } else if (customTypeObject instanceof Date) {
            CodecUtil.appendText((String)Converter.fromDateTime((Date)customTypeObject), (Result)attributeElement);
        }
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription ai) throws CodecException {
        Element attrElement = CodecUtil.asElement((Source)attributeElement);
        Class cls = null;
        String t = attrElement.getAttribute("type");
        if (t != null && t.length() > 0) {
            try {
                cls = this.classFromXmlName(t);
            }
            catch (Exception e) {
                throw new CodecException("Error creating list contaner", (Throwable)e);
            }
        }
        if (cls == null) {
            if (ai == null || ai.getValueType() == null) {
                throw new CodecException("No meta information for '" + attrElement.getNodeName() + "'");
            }
            cls = ai.getValueType();
        }
        return this.decodeFromXml(attributeElement, cls);
    }

    protected Object decodeFromXml(Source attributeElement, Class cls) throws CodecException {
        Element attrElement = CodecUtil.asElement((Source)attributeElement);
        if (BaseEntityAttributes.class.isAssignableFrom(cls)) {
            Node chNode = attrElement.getFirstChild();
            String clName = chNode.getNodeName();
            try {
                Class chCls = this.classFromXmlName(clName);
                return this.xmlToObject(chNode, chCls);
            }
            catch (Exception e) {
                throw new CodecException("Error creating EntityAttributes class", (Throwable)e);
            }
        }
        if (BaseSearchCriteria.class.isAssignableFrom(cls)) {
            Node chNode = attrElement.getFirstChild();
            String clName = chNode.getNodeName();
            try {
                Class chCls = this.classFromXmlName(clName);
                return this.xmlToObject(chNode, chCls);
            }
            catch (Exception e) {
                throw new CodecException("Error creating SearchCriteria class", (Throwable)e);
            }
        }
        if (XmlSerializable.class.isAssignableFrom(cls)) {
            return this.xmlToObject(attrElement, cls);
        }
        if (List.class.isAssignableFrom(cls)) {
            List lst;
            try {
                lst = (List)cls.newInstance();
            }
            catch (Exception e) {
                throw new CodecException("Error creating list contaner", (Throwable)e);
            }
            if (attrElement.hasChildNodes()) {
                for (Node child = attrElement.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String type = ((Element)child).getAttribute("type");
                    if (type == null || type.length() == 0) {
                        type = child.getNodeName();
                    }
                    try {
                        lst.add(this.xmlToObject(child, this.classFromXmlName(type)));
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new CodecException("Error creating list element", (Throwable)e);
                    }
                }
            }
            return lst;
        }
        if (NamedGEnum.class.isAssignableFrom(cls)) {
            String sval = XmlUtil.getElementText((Element)attrElement);
            NamedGEnum oval = NamedGEnum.getValue(cls, sval);
            if (oval == null) {
                throw new CodecException("Wrong value for \"" + cls.getName() + "\" (\"" + sval + "\")");
            }
            return oval;
        }
        if (Date.class.isAssignableFrom(cls)) {
            String sval = XmlUtil.getElementText((Element)attrElement);
            try {
                return Converter.toDateTime(sval);
            }
            catch (Exception e) {
                throw new CodecException("Error parsing DateTime field value \"" + sval + "\"", (Throwable)e);
            }
        }
        throw new CodecException("Unsupported object type: " + cls);
    }

    public Object xmlToObject(Node nav, Class t) throws CodecException {
        String sval = nav.getTextContent();
        if (Integer.class.equals((Object)t)) {
            return Integer.valueOf(sval);
        }
        if (Boolean.class.equals((Object)t)) {
            return Integer.parseInt(sval) == 1;
        }
        if (String.class.equals((Object)t)) {
            return sval;
        }
        if (Date.class.equals((Object)t)) {
            try {
                return Converter.toDateTime(sval);
            }
            catch (Exception e) {
                throw new CodecException("Error parsing DateTime field value \"" + sval + "\"", (Throwable)e);
            }
        }
        if (byte[].class.equals((Object)t)) {
            return Base64.decodeBase64((byte[])sval.getBytes());
        }
        if (NamedGEnum.class.isAssignableFrom(t)) {
            return NamedGEnum.getValue(t, sval);
        }
        if (GEnum.class.isAssignableFrom(t)) {
            return GEnum.getValue((Class)t, (String)sval);
        }
        if (KeyValueCollection.class.equals((Object)t)) {
            return this.tkvCodec.decodeFromXml((Source)new DOMSource(nav), null);
        }
        if (XmlSerializable.class.isAssignableFrom(t)) {
            try {
                XmlSerializable ret = (XmlSerializable)t.newInstance();
                ret.loadFromXml(this, nav);
                return ret;
            }
            catch (Exception e) {
                throw new CodecException("Type " + t + " is not supported. If it is a custom-type, it shall imlement ICodec interface.", (Throwable)e);
            }
        }
        if (AbstractList.class.isAssignableFrom(t)) {
            return this.decodeFromXml((Source)new DOMSource(nav), t);
        }
        throw new CodecException("Type " + t + " is not supported. If it is a custom-type, it shall imlement ICodec interface.");
    }

    public void objectToXml(Object obj, Element root) throws CodecException {
        if (obj == null) {
            return;
        }
        Document doc = root.getOwnerDocument();
        if (obj instanceof Integer) {
            root.appendChild(doc.createTextNode(obj.toString()));
        } else if (obj instanceof Long) {
            root.appendChild(doc.createTextNode(obj.toString()));
        } else if (obj instanceof String) {
            root.appendChild(doc.createTextNode((String)obj));
        } else if (obj instanceof Boolean) {
            root.appendChild(doc.createTextNode((Boolean)obj != false ? "1" : "0"));
        } else if (obj instanceof Date) {
            root.appendChild(doc.createTextNode(Converter.fromDateTime((Date)obj)));
        } else if (obj instanceof byte[]) {
            root.appendChild(doc.createTextNode(new String(Base64.encodeBase64((byte[])((byte[])obj)))));
        } else if (obj instanceof NamedGEnum) {
            root.appendChild(doc.createTextNode(((NamedGEnum)((Object)obj)).getLongName()));
        } else if (obj instanceof GEnum) {
            root.appendChild(doc.createTextNode(obj.toString()));
        } else if (obj instanceof KeyValueCollection) {
            this.tkvCodec.encodeToXml(obj, (Result)new DOMResult(root));
        } else if (obj instanceof XmlSerializable) {
            ((XmlSerializable)obj).saveToXml(this, root);
        } else if (obj instanceof AbstractList) {
            this.encodeToXml(obj, new DOMResult(root));
        } else {
            throw new CodecException("Type " + obj.getClass().getName() + " is not supported. If it is a custom-type, it shall imlement ICodec interface.");
        }
    }

    public String getLogType() {
        return "list";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) {
        StringList list = (StringList)customTypeObject;
        CodecUtil.appendBytesStr((StringBuffer)buf, (byte[])list.toString().getBytes(), (boolean)truncate);
    }

    protected String className4xml(Class cls) {
        String name = cls.getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    protected Class classFromXmlName(String name) throws ClassNotFoundException {
        return MessageTypeResolver.classForName((String)name, (String)"com.genesyslab.platform.contacts.protocol.contactserver.", (String)"Genesyslab.Platform.Contacts.Protocols.ContactServer.", (ClassLoader)UCSCustomCodec.class.getClassLoader());
    }
}

