/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.protocol.Channel;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;

public class ChannelClosedEvent
extends ChannelErrorEvent {
    private ChannelState prevState;
    private long unsentBytes;
    private Endpoint endpoint;

    public ChannelClosedEvent(Channel source) {
        this(source, (Throwable)null, null);
    }

    public ChannelClosedEvent(Channel source, Throwable cause, ChannelState prevState, Endpoint endpoint) {
        super(source, cause);
        this.prevState = prevState;
        try {
            this.endpoint = endpoint != null ? (Endpoint)endpoint.clone() : null;
        }
        catch (CloneNotSupportedException e) {
            this.endpoint = endpoint;
        }
    }

    public ChannelClosedEvent(Channel source, Throwable cause, ChannelState prevState) {
        super(source, cause);
        this.prevState = prevState;
        if (source instanceof EndpointSupport) {
            Endpoint tmp = ((EndpointSupport)((Object)source)).getEndpoint();
            try {
                this.endpoint = tmp != null ? (Endpoint)tmp.clone() : null;
            }
            catch (CloneNotSupportedException e) {
                this.endpoint = tmp;
            }
        }
    }

    public ChannelClosedEvent(Channel source, ConnectionClosedEvent ccEvent, ChannelState prevState) {
        this(source, ccEvent.getCause(), prevState);
    }

    public ChannelState getPreviousChannelState() {
        return this.prevState;
    }

    @Override
    public String toString() {
        return super.toString() + "; prev.state: " + (Object)((Object)this.prevState) + (this.endpoint != null ? "; endpoint=" + this.endpoint : "");
    }

    public boolean hasUnsentBytes() {
        return this.unsentBytes > 0L;
    }

    public long getUnsentBytes() {
        return this.unsentBytes;
    }

    void setUnsentBytes(long unsentBytes) {
        this.unsentBytes = unsentBytes;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

