/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.protocol.ClientChannelHandler;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;

public class ClientChannelHandlerFactory {
    private final ProtocolFactory protocolFactory;

    public ClientChannelHandlerFactory(ProtocolFactory protocolFactory) {
        if (protocolFactory == null) {
            throw new IllegalStateException("No protocol factory given for ClientChannelHandlerFactory");
        }
        this.protocolFactory = protocolFactory;
    }

    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public ClientChannelHandler createHandler(Connection connection, ConnectionConfiguration config) {
        if (connection == null) {
            throw new IllegalArgumentException("Null Connection reference for ClientChannelHandlerFactory");
        }
        return new ClientChannelHandler(connection, config, this.protocolFactory);
    }
}

