/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.codec.ValueAdjustment;
import com.genesyslab.platform.commons.util.CompareUtils;
import java.util.HashSet;
import java.util.Map;

public abstract class DataObject {
    public String toString() {
        return this.toString(true, true);
    }

    public abstract String toString(boolean var1, boolean var2);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (this instanceof DataSupport && obj instanceof DataSupport) {
            DataSupport thisData = (DataSupport)((Object)this);
            DataSupport otherData = (DataSupport)obj;
            if (!this.equals(thisData.attributes(), otherData.attributes(), false, this)) {
                return false;
            }
            return this.equals(thisData.getCompounds(), otherData.getCompounds(), true, this);
        }
        return super.equals(obj);
    }

    private boolean equals(Map thisAttrs, Map otherAttrs, boolean compound, DataObject parent) {
        MetaData meta = ((DataSupport)((Object)this)).getMetaData();
        HashSet remainedOtherKeys = new HashSet(otherAttrs.keySet());
        for (Map.Entry thisEntry : thisAttrs.entrySet()) {
            ValueAdjustment va;
            String key = (String)thisEntry.getKey();
            Object thisValue = thisEntry.getValue();
            Object otherValue = otherAttrs.get(key);
            remainedOtherKeys.remove(key);
            if (thisValue == null && otherValue == null) continue;
            if (compound) {
                if (parent != null) {
                    try {
                        parent.getClass().getMethod("get" + key, null);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            parent.getClass().getSuperclass().getMethod("get" + key, null);
                        }
                        catch (NoSuchMethodException e2) {
                            continue;
                        }
                    }
                }
                if (thisValue == null ^ otherValue == null) {
                    return false;
                }
                if (CompareUtils.deepEquals(thisValue, otherValue)) continue;
                return false;
            }
            AttributeDescription ad = meta.getAttributeDescription(key);
            if (ad != null && (ad.isHidden() || ad.isSerializationHidden())) continue;
            if (thisValue == null ^ otherValue == null) {
                return false;
            }
            ValueAdjustment valueAdjustment = va = ad != null ? ad.getValueAdjustment() : null;
            if (!(va != null ? !va.isAdjustedEquals(thisValue, otherValue) : !CompareUtils.deepEquals(thisValue, otherValue))) continue;
            return false;
        }
        for (String key : remainedOtherKeys) {
            Object otherValue = otherAttrs.get(key);
            if (otherValue == null) continue;
            if (compound) {
                if (parent != null) {
                    try {
                        parent.getClass().getMethod("get" + key, null);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            parent.getClass().getSuperclass().getMethod("get" + key, null);
                        }
                        catch (NoSuchMethodException e2) {
                            continue;
                        }
                    }
                }
            } else {
                AttributeDescription ad = meta.getAttributeDescription(key);
                if (ad != null && (ad.isHidden() || ad.isSerializationHidden())) continue;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this instanceof DataSupport) {
            DataSupport thisData = (DataSupport)((Object)this);
            return 7 * this.hashCode(thisData.attributes()) + 11 * this.hashCode(thisData.getCompounds());
        }
        return super.hashCode();
    }

    private int hashCode(Map attributes) {
        int hash = 0;
        MetaData meta = ((DataSupport)((Object)this)).getMetaData();
        for (Map.Entry entry : attributes.entrySet()) {
            AttributeDescription ad;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || (ad = meta.getAttributeDescription(key)) != null && ad.isHidden()) continue;
            hash = 31 * hash + CompareUtils.hashCode((Object)key);
            hash = 31 * hash + CompareUtils.hashCode(value);
        }
        return hash;
    }
}

