/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Listener;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListenerHelper {
    private static final ILogger log = Log.getLogger(ListenerHelper.class);
    private CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    public void addListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(Listener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void notifyListeners(NotificationVisitor notificationVisitor) {
        int size = this.listeners.size();
        if (log.isDebug() && size > 0) {
            log.debugFormat("Notifying {0} listener(s)", (Object)size);
        }
        int success = 0;
        for (Listener listener : this.listeners) {
            try {
                notificationVisitor.visitListener(listener);
                ++success;
            }
            catch (Throwable e) {
                log.debug((Object)"Exception in listener", e);
            }
        }
        if (log.isDebug() && size > 0) {
            log.debugFormat("{0} listener(s) understood the event right", (Object)success);
        }
    }

    public Runnable createNotificationTask(final NotificationVisitor visitor) {
        return new Runnable(){
            Iterator<Listener> it;
            {
                this.it = ListenerHelper.this.listeners.iterator();
            }

            @Override
            public void run() {
                int size = ListenerHelper.this.listeners.size();
                if (log.isDebug() && size > 0) {
                    log.debugFormat("Notifying {0} listener(s)", (Object)size);
                }
                int success = 0;
                while (this.it.hasNext()) {
                    Listener listener = this.it.next();
                    try {
                        visitor.visitListener(listener);
                        ++success;
                    }
                    catch (Throwable e) {
                        log.debug((Object)"Exception in listener", e);
                    }
                }
                if (log.isDebug() && size > 0) {
                    log.debugFormat("{0} listener(s) understood the event right", (Object)success);
                }
            }
        };
    }

    public static interface NotificationVisitor {
        public void visitListener(Listener var1);
    }
}

