/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.impl.CommonMessageProducerImpl;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolMessagePackagerImpl;

public class MessageParser {
    private ProtocolFactory factory;
    private ProtocolMessagePackagerImpl packager;
    private MessageHandler messageHandler = new MessageHandler();
    private ErrorHandler errorHandler;
    private String stringAttributesEncoding;

    public MessageParser(ProtocolFactory protocolFactory) {
        this(protocolFactory, EncodingSupport.DEFAULT_ENCODING);
    }

    public MessageParser(ProtocolFactory protocolFactory, String stringAttributesEncoding) {
        this.factory = protocolFactory;
        this.stringAttributesEncoding = stringAttributesEncoding;
        this.packager = new ProtocolMessagePackagerImpl(this.factory, null, this.messageHandler, new DelegatingErrorHandler());
    }

    public ProtocolFactory getFactory() {
        return this.factory;
    }

    public Message parse(byte[] bytes, int pos, int len) throws ProtocolException {
        CommonMessageProducerImpl producer = new CommonMessageProducerImpl(bytes, pos, (MessagePackager)this.packager, this.stringAttributesEncoding, null);
        try {
            producer.parse();
        }
        catch (InvalidPacketException e) {
            throw new ProtocolException("Can't parse message", e);
        }
        return this.messageHandler.message();
    }

    public Message parse(byte[] bytes) throws ProtocolException {
        return this.parse(bytes, 0, bytes.length);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private class MessageHandler
    implements ProtocolMessagePackagerImpl.MessageHandler {
        private Message message;

        private MessageHandler() {
        }

        @Override
        public void onMessage(Message message) {
            this.message = message;
        }

        public Message message() {
            return this.message;
        }
    }

    private class DelegatingErrorHandler
    implements ProtocolMessagePackagerImpl.ErrorHandler {
        private DelegatingErrorHandler() {
        }

        @Override
        public void handleError(ProtocolException e) {
            if (MessageParser.this.errorHandler != null) {
                MessageParser.this.errorHandler.handleError(e);
            }
        }
    }

    public static interface ErrorHandler {
        public void handleError(ProtocolException var1);
    }
}

