/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.auth.AcquireKerberosTicketAction;
import com.genesyslab.platform.commons.protocol.auth.AuthTicket;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketAcquirer;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketAcquirerException;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketData;
import com.genesyslab.platform.commons.protocol.auth.GssOptions;
import com.genesyslab.platform.commons.protocol.auth.KerberosUtil;
import com.sun.security.auth.module.Krb5LoginModule;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;

public class KerberosTicketAcquirer
implements AuthTicketAcquirer {
    private static final ILogger log = Log.getLogger(KerberosTicketAcquirer.class);
    private static final long ALMOST_EXPIRED_PERIOD = 300000L;
    private String userPrincipalName;
    private CallbackHandler callbackHandler;
    private GssOptions gssOptions;
    private Map<String, String> kerberosOptions;
    private Krb5LoginModule loginModule;
    private SubjectWrapper subjectWrapper;
    private boolean useGss = true;
    private boolean useTicketsCache = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(SubjectWrapper subjectWrapper, String userPrincipalName, CallbackHandler callbackHandler, Map<String, String> kerberosOptions) throws LoginException {
        SubjectWrapper subjectWrapper2 = this.subjectWrapper = null == subjectWrapper ? new SubjectWrapper() : subjectWrapper;
        if (null != userPrincipalName && userPrincipalName.length() > 0) {
            this.userPrincipalName = userPrincipalName;
        }
        this.gssOptions = new GssOptions();
        this.callbackHandler = callbackHandler;
        this.kerberosOptions = kerberosOptions != null ? new HashMap<String, String>(kerberosOptions) : this.createKerberosOptions(callbackHandler);
        SubjectWrapper subjectWrapper3 = this.subjectWrapper;
        synchronized (subjectWrapper3) {
            this.login();
            if (null == userPrincipalName) {
                Principal principal = KerberosUtil.getSinglePrincipal(this.subjectWrapper.subject.getPrincipals());
                this.userPrincipalName = principal.getName();
            }
        }
        log.debugFormat("KerberosTicketAcquirer initialized. UPN={0}", (Object)("" + this.userPrincipalName));
    }

    private KerberosTicketAcquirer(SubjectWrapper subjectWrapper, String userPrincipalName, CallbackHandler callbackHandler, Map<String, String> kerberosOptions) throws LoginException {
        this.init(subjectWrapper, userPrincipalName, callbackHandler, kerberosOptions);
    }

    public KerberosTicketAcquirer() throws LoginException {
        this.init(null, null, null, null);
    }

    public KerberosTicketAcquirer(String userPrincipalName, CallbackHandler callbackHandler) throws LoginException {
        this(userPrincipalName, callbackHandler, null);
    }

    public KerberosTicketAcquirer(Map<String, String> kerberosOptions) throws LoginException {
        this.init(null, null, null, kerberosOptions);
    }

    public KerberosTicketAcquirer(String userPrincipalName, CallbackHandler callbackHandler, Map<String, String> kerberosOptions) throws LoginException {
        if (userPrincipalName == null) {
            throw new IllegalArgumentException("UPN is null");
        }
        if (callbackHandler == null) {
            throw new IllegalArgumentException("callback handler is null");
        }
        this.init(null, userPrincipalName, callbackHandler, kerberosOptions);
    }

    private void login() throws LoginException {
        this.loginModule = new Krb5LoginModule();
        this.loginModule.initialize(this.subjectWrapper.subject, this.callbackHandler, null, this.kerberosOptions);
        this.loginModule.login();
        this.loginModule.commit();
    }

    private Map<String, String> createKerberosOptions(CallbackHandler callbackHandler) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null != this.userPrincipalName && this.userPrincipalName.length() > 0) {
            result.put("principal", this.userPrincipalName);
        }
        result.put("doNotPrompt", Boolean.toString(null == callbackHandler));
        result.put("useTicketCache", Boolean.toString(null == callbackHandler));
        result.put("isInitiator", "true");
        return result;
    }

    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    public Map<String, String> getKerberosOptions() {
        return new HashMap<String, String>(this.kerberosOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthTicket acquireTicket(String servicePrincipalName) throws AuthTicketAcquirerException {
        KerberosTicket ticket;
        SubjectWrapper subjectWrapper;
        byte[] gssTicketBytes;
        if (null == servicePrincipalName) {
            throw new IllegalArgumentException("servicePrincipalName must not be null");
        }
        if (0 == servicePrincipalName.length()) {
            throw new IllegalArgumentException("servicePrincipalName must not be empty");
        }
        if (log.isDebug()) {
            log.debugFormat("KerberosTicketAcquirer: Trying to obtain Kerberos ticket for SPN: ''{0}'' for user: ''{1}''", (Object)new Object[]{servicePrincipalName, "" + this.userPrincipalName});
        }
        boolean gss = this.useGss;
        if (this.useTicketsCache) {
            KerberosTicket ticket2 = null;
            gssTicketBytes = null;
            subjectWrapper = this.subjectWrapper;
            synchronized (subjectWrapper) {
                TicketCacheItem tki = (TicketCacheItem)this.subjectWrapper.cache.get(servicePrincipalName);
                if (tki != null && System.currentTimeMillis() >= tki.ticket.getEndTime().getTime() - 300000L) {
                    this.subjectWrapper.cache.remove(servicePrincipalName);
                    tki = null;
                }
                if (tki != null) {
                    ticket2 = tki.ticket;
                    gssTicketBytes = tki.gssTicketBytes;
                }
            }
            if (ticket2 != null) {
                return new AuthTicketData(this.getTicketBytes(gssTicketBytes, gss), servicePrincipalName, this.userPrincipalName, ticket2.getAuthTime(), ticket2.getStartTime(), ticket2.getEndTime(), ticket2.getRenewTill(), gss);
            }
        }
        AcquireKerberosTicketAction action = new AcquireKerberosTicketAction(this.userPrincipalName, servicePrincipalName, this.gssOptions);
        gssTicketBytes = null;
        try {
            subjectWrapper = this.subjectWrapper;
            synchronized (subjectWrapper) {
                gssTicketBytes = Subject.doAsPrivileged(this.subjectWrapper.subject, action, null);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error acquiring Kerberos ticket", e);
            throw new AuthTicketAcquirerException("Error acquiring Kerberos ticket", e);
        }
        if (null == gssTicketBytes) {
            throw new AuthTicketAcquirerException("no ticket");
        }
        byte[] ticketBytes = this.getTicketBytes(gssTicketBytes, gss);
        SubjectWrapper subjectWrapper2 = this.subjectWrapper;
        synchronized (subjectWrapper2) {
            ticket = KerberosUtil.getKerberosTicket(this.subjectWrapper.subject, servicePrincipalName);
            if (null == ticket) {
                this.subjectWrapper.cache.remove(servicePrincipalName);
            } else {
                this.subjectWrapper.cache.put(servicePrincipalName, new TicketCacheItem(gssTicketBytes, ticket));
            }
        }
        if (null == ticket) {
            return new AuthTicketData(ticketBytes, servicePrincipalName, this.userPrincipalName, gss);
        }
        return new AuthTicketData(ticketBytes, servicePrincipalName, this.userPrincipalName, ticket.getAuthTime(), ticket.getStartTime(), ticket.getEndTime(), ticket.getRenewTill(), gss);
    }

    private byte[] getTicketBytes(byte[] ticketBytes, boolean useGss) throws AuthTicketAcquirerException {
        if (!useGss) {
            log.error((Object)"Error acquiring Kerberos ticket: could not parse GSS token");
            throw new AuthTicketAcquirerException("Error acquiring Kerberos ticket: could not parse GSS token");
        }
        return ticketBytes;
    }

    private boolean getUseGSS() {
        return this.useGss;
    }

    private void setUseGSS(boolean useGSS) {
        this.useGss = useGSS;
    }

    private boolean isUseTicketsCache() {
        return this.useTicketsCache;
    }

    private void setUseTicketsCache(boolean useTicketCache) {
        this.useTicketsCache = useTicketCache;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append(super.toString());
        String upn = this.userPrincipalName;
        if (upn != null) {
            sb.append(" UPN:");
            sb.append(upn);
        }
        if (this.callbackHandler != null) {
            sb.append(" CALLBACK");
        }
        if (this.useGss) {
            sb.append(" useGss");
        }
        if (this.useTicketsCache) {
            sb.append(" useTicketsCache");
        }
        return sb.toString();
    }

    private static final class SubjectWrapper {
        private final Subject subject = new Subject();
        private final Map<String, TicketCacheItem> cache = new HashMap<String, TicketCacheItem>();

        private SubjectWrapper() {
        }
    }

    private static final class TicketCacheItem {
        final byte[] gssTicketBytes;
        final KerberosTicket ticket;

        public TicketCacheItem(byte[] bytes, KerberosTicket ticket) {
            this.gssTicketBytes = bytes;
            this.ticket = ticket;
        }
    }
}

