/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import java.security.Principal;
import java.util.Collection;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

class KerberosUtil {
    KerberosUtil() {
    }

    public static Oid getKerberosPrincipalNameOid() {
        try {
            return new Oid("1.2.840.113554.1.2.2.1");
        }
        catch (GSSException e) {
            return null;
        }
    }

    public static Oid getKerberos5Oid() {
        try {
            return new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            return null;
        }
    }

    public static Principal getSinglePrincipal(Collection<Principal> principals) {
        if (principals.isEmpty()) {
            throw new IllegalArgumentException("principals is empty");
        }
        if (principals.size() > 1) {
            throw new IllegalArgumentException("principals argument contains more than one principal");
        }
        return principals.iterator().next();
    }

    public static KerberosTicket getTGT(Subject subject) {
        for (Object o : subject.getPrivateCredentials()) {
            KerberosTicket kt;
            if (!(o instanceof KerberosTicket) || !(kt = (KerberosTicket)o).getServer().getName().startsWith("krbtgt")) continue;
            return kt;
        }
        return null;
    }

    public static KerberosTicket getKerberosTicket(Subject subject, String servicePrincipalName) {
        if (null == servicePrincipalName) {
            return null;
        }
        for (Object o : subject.getPrivateCredentials()) {
            if (!(o instanceof KerberosTicket)) continue;
            KerberosTicket kt = (KerberosTicket)o;
            String spn = kt.getServer().getName();
            if (servicePrincipalName.equals(spn)) {
                return kt;
            }
            String realm = kt.getServer().getRealm();
            if (realm == null) continue;
            if (!realm.startsWith("@")) {
                realm = "@" + realm;
            }
            if (!servicePrincipalName.equals(spn = spn.endsWith(realm) ? spn.substring(0, spn.length() - realm.length()) : spn + realm)) continue;
            return kt;
        }
        return null;
    }
}

