/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AbstractCodecAttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.LazyParsingPossible;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.ValueAdjustment;
import com.genesyslab.platform.commons.protocol.runtime.codec.ValueAdjustmentSupport;
import java.lang.reflect.Constructor;

public class CodecAttributeDescription<T extends CustomTypeCodec>
extends AbstractCodecAttributeDescription
implements LazyParsingPossible {
    private static final ILogger log = Log.getLogger(CodecAttributeDescription.class);
    private boolean lazyPossible = false;
    private Class<T> codecClass;
    private Constructor<T> codecConstructor = null;
    private ValueAdjustment valueAdjustment;

    public CodecAttributeDescription(Class<T> codecClass, String id, String name, Class valueType, Class enumClass, String logName, boolean logHidden) {
        this(codecClass, id, name, valueType, enumClass, logName, false, logHidden, false);
    }

    public CodecAttributeDescription(Class<T> codecClass, String id, String name, Class valueType, Class enumClass, String logName, boolean srlzHidden, boolean logHidden, boolean lazyPossible) {
        super(id, name, valueType, enumClass, logName, srlzHidden, logHidden);
        this.codecClass = codecClass;
        try {
            this.codecConstructor = codecClass.getConstructor(new Class[0]);
            if (ValueAdjustmentSupport.class.isAssignableFrom(codecClass)) {
                this.valueAdjustment = ((ValueAdjustmentSupport)((Object)this.createCodec(null, null))).getValueAdjustment();
            }
        }
        catch (Exception e) {
            log.error((Object)"codec constructor getting problem", (Throwable)e);
        }
        this.lazyPossible = lazyPossible;
    }

    @Override
    public ValueAdjustment getValueAdjustment() {
        return this.valueAdjustment;
    }

    @Override
    public boolean hasCodec() {
        return this.codecConstructor != null;
    }

    @Override
    public CustomTypeCodec createCodec(Message message, Object protocolData) {
        CustomTypeCodec codec = null;
        if (this.codecConstructor != null) {
            try {
                codec = (CustomTypeCodec)this.codecConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)"codec constructor getting problem", (Throwable)e);
            }
        }
        if (codec != null) {
            if (message != null) {
                codec.setMessage(message);
            }
            if (protocolData != null) {
                codec.setProtocolData(protocolData);
            }
        }
        return codec;
    }

    @Override
    public boolean isSameCodec(Object o) {
        if (o == null) {
            return false;
        }
        return this.codecClass == o.getClass();
    }

    @Override
    public boolean isLazyParsingPossible() {
        return this.lazyPossible;
    }

    @Override
    public String getLogSignature() {
        CustomTypeCodec createCodec;
        if (this.logSignature == null && (createCodec = this.createCodec(null, null)) != null) {
            this.logSignature = createCodec.getLogType();
        }
        return this.logSignature;
    }
}

