/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.ToStringHelper;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

public final class LogHiddenAttributes {
    private static final ILogger log = Log.getLogger(ToStringHelper.class);
    private final ConcurrentMap<String, Map<String, AttributeSet>> configuration = new ConcurrentHashMap<String, Map<String, AttributeSet>>();

    public synchronized void hide(String protocolName, String attributeHolderName, String attributeName) throws NullPointerException {
        LogHiddenAttributes.validateArgs("protocolName", protocolName);
        LogHiddenAttributes.validateArgs("className", attributeHolderName);
        LogHiddenAttributes.validateArgs("attributeName", attributeName);
        this.addAttribute(protocolName, attributeHolderName, attributeName);
    }

    public synchronized void unhide(String protocolName, String attributeHolderName, String attributeName) throws NullPointerException {
        LogHiddenAttributes.validateArgs("protocolName", protocolName);
        LogHiddenAttributes.validateArgs("className", attributeHolderName);
        LogHiddenAttributes.validateArgs("attributeName", attributeName);
        this.removeAttribute(protocolName, attributeHolderName, attributeName);
    }

    public synchronized void setHiddenAttributes(String protocolName, String attributeHolderName, Set<String> attributes) throws NullPointerException {
        AttributeSet classConfig;
        LogHiddenAttributes.validateArgs("protocolName", protocolName);
        LogHiddenAttributes.validateArgs("className", attributeHolderName);
        ConcurrentHashMap<String, AttributeSet> protocolConfig = (ConcurrentHashMap<String, AttributeSet>)this.configuration.get(protocolName);
        if (protocolConfig == null) {
            protocolConfig = new ConcurrentHashMap<String, AttributeSet>();
            this.configuration.put(protocolName, protocolConfig);
        }
        if ((classConfig = (AttributeSet)protocolConfig.get(attributeHolderName)) == null) {
            classConfig = new AttributeSet(attributes);
            protocolConfig.put(attributeHolderName, classConfig);
        } else {
            classConfig.set(attributes);
        }
        log.debug((Object)String.format("Set hidden attributes for %s:%s", protocolName, attributeHolderName));
    }

    public boolean isLogHidden(String protocolName, String attributeHolderName, String attributeName) {
        if (protocolName == null || attributeHolderName == null || attributeName == null) {
            return false;
        }
        Map protocolConfig = (Map)this.configuration.get(protocolName);
        if (protocolConfig == null) {
            return false;
        }
        AttributeSet objectConfig = (AttributeSet)protocolConfig.get(attributeHolderName);
        if (objectConfig == null) {
            return false;
        }
        return objectConfig.contains(attributeName);
    }

    public AttributeSet getHiddenSet(String protocolName, String className) {
        if (protocolName == null || className == null) {
            return null;
        }
        Map protocolConfig = (Map)this.configuration.get(protocolName);
        if (protocolConfig == null) {
            return null;
        }
        return (AttributeSet)protocolConfig.get(className);
    }

    private void addAttribute(String protocolName, String attributeHolderName, String attributeName) {
        AttributeSet classConfig;
        ConcurrentHashMap<String, AttributeSet> protocolConfig = (ConcurrentHashMap<String, AttributeSet>)this.configuration.get(protocolName);
        if (protocolConfig == null) {
            protocolConfig = new ConcurrentHashMap<String, AttributeSet>();
            this.configuration.put(protocolName, protocolConfig);
        }
        if ((classConfig = (AttributeSet)protocolConfig.get(attributeHolderName)) == null) {
            classConfig = new AttributeSet();
            protocolConfig.put(attributeHolderName, classConfig);
        }
        classConfig.add(attributeName);
        log.debug((Object)String.format("Added hidden attribute '%s', %s:%s", attributeName, protocolName, attributeHolderName));
    }

    private void removeAttribute(String protocolName, String className, String attributeName) {
        Map protocolConfig = (Map)this.configuration.get(protocolName);
        if (protocolConfig == null) {
            log.debug((Object)String.format("No hidden attribute '%s' in %s:%s", attributeName, protocolName, className));
        } else {
            AttributeSet classConfig = (AttributeSet)protocolConfig.get(className);
            if (classConfig == null) {
                log.debug((Object)String.format("No hidden attribute '%s' in %s:%s", attributeName, protocolName, className));
            } else {
                classConfig.remove(attributeName);
                log.debug((Object)String.format("Removed hidden attribute '%s', %s:%s", attributeName, protocolName, className));
            }
        }
    }

    private static void validateArgs(String name, String value) {
        if (value == null) {
            throw new NullPointerException(name + " can't be null");
        }
    }

    public static class AttributeSet {
        private final CopyOnWriteArraySet<String> attributes;

        public AttributeSet() {
            this.attributes = new CopyOnWriteArraySet();
        }

        public AttributeSet(Set<String> attributes) {
            this.attributes = attributes != null ? new CopyOnWriteArraySet<String>(attributes) : new CopyOnWriteArraySet();
        }

        public boolean contains(String name) {
            if (name == null) {
                return false;
            }
            return this.attributes.contains(name);
        }

        void add(String name) {
            if (name != null) {
                this.attributes.add(name);
            }
        }

        void remove(String name) {
            if (name != null) {
                this.attributes.remove(name);
            }
        }

        void set(Set<String> attributes) {
            if (attributes == null || attributes.isEmpty()) {
                this.attributes.clear();
            } else {
                this.attributes.addAll(attributes);
            }
        }
    }
}

